package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmPaymentProjectInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题 BcmPaymentProjectInfoMapper
 * 说明 收支项目Mapper
 * 时间 2023/7/21 14:27
 *
 * @author 唐富强
 */
@Mapper
@Repository
public interface BcmPaymentProjectInfoMapper {

    /**
     * 收支项目列表查询（分页）
     * @param po
     * @param page
     * @return
     */
    List<BcmPaymentProjectInfoPO> getListPage(BcmPaymentProjectInfoPO po, Page<BcmPaymentProjectInfoPO> page);

    /**
     * 查询未关联采购用途的启用收支项目
     * @param po 参数对象
     * @return List<BcmPaymentProjectInfoPO> 结果对象
     */
    List<BcmPaymentProjectInfoPO> queryNotRelPurchasePurposeForPaymentProjectList(BcmPaymentProjectInfoPO po, Page<BcmPaymentProjectInfoPO> page);
}
