package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 上架申请单;
 * @author : civism
 * @date : 2023-7-28
 */
@Data
public class BcmApplyCommodityOrderPO implements Serializable{
    private static final long serialVersionUID = -6575086931078277113L;
    /**
     * ID
     */
    private Long id ;
    /**
     * 上架申请单Id
     */
    private Long applyOrderId ;
    /**
     * 上架申请单编号
     */
    private String applyOrderCode ;
    /**
     * 上架申请单名称
     */
    private String applyOrderName ;
    /**
     * 上架申请单状态：
     1：草稿；2：申请审批中；3：应答中；4：选定中；5：已选定
     6：结果审批中；7：已完成；8：已终止
     */
    private Integer applyOrderStatus ;
    /**
     * 采购单位id
     */
    private Long purCompanyId ;
    /**
     * 采购单位名称
     */
    private String purCompanyName ;
    /**
     * 联系电话
     */
    private String applyUserPhone ;
    /**
     * 是否为定制商品0是1否
     */
    private Integer isCustomizedFlag ;
    /**
     * 挂接商品截止日期
     */
    private Date hitchDeadlineDate ;
    /**
     * 选定截止日期
     */
    private Date selectDeadlineDate ;
    /**
     * 应答截止日期
     */
    private Date replyDeadlineDate ;
    /**
     * 应答期限（日）
     */
    private Integer replyDayLimit ;
    /**
     * 发起人机构id
     */
    private Long applyUserOrgId ;
    /**
     * 发起人机构名称
     */
    private String applyUserOrgName ;
    /**
     * 发起人id
     */
    private Long applyUserId ;
    /**
     * 发起人名称
     */
    private String applyUserName ;
    /**
     * 发起人公司id
     */
    private Long applyUserCompanyId ;
    /**
     * 发起人公司名称
     */
    private String applyUserCompanyName ;
    /**
     * 取消类型
     */
    private Integer cancelType ;
    /**
     * 取消原因
     */
    private String cancelReason ;
    /**
     * 删除标志（0代表存在 1代表删除）
     */
    private Integer delFlag ;
    /**
     * 创建人id
     */
    private Long createUserId ;
    /**
     * 创建人名称
     */
    private String createUserName ;
    /**
     * 创建时间
     */
    private Date createTime ;
    /**
     * 更新人id
     */
    private Long updateUserId ;
    /**
     * 更新人名称
     */
    private String updateUserName ;
    /**
     * 更新时间
     */
    private Date updateTime ;

    /**
     * 任务ID
     */
    private Long taskId;

    /**
     * 提交开始时间
     */
    private Date createStartTime;

    /**
     * 提交结束时间
     */
    private Date createEndTime;

    /**
     * 截止应答开始时间
     */
    private Date replyDeadlineStartDate;

    /**
     * 截止应答结束时间
     */
    private Date replyDeadlineEndDate;

    /**
     * 任务状态
     * 任务状态1待审核2已通过3已驳回4已取消
     */
    private List<Integer> taskStatus;

    /**
     * 流程类型：
     * 1：上架申请审批
     * 2：上架申请选定结果审批
     */
    private Integer flowType;
}