package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import com.tydic.bcm.personal.commodity.api.BcmAddApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmAddApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmAddApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

import java.util.Date;
import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/7/28 11:07
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmAddApplyCommodityOrderServiceImpl implements BcmAddApplyCommodityOrderService {


    private final BcmApplyCommodityOrderMapper commodityOrderMapper;

    private final BcmApplyCommodityOrderItemMapper commodityOrderItemMapper;

    private final BcmFileMapper fileMapper;

    @Override
    public BcmAddApplyCommodityOrderRspBO addApplyCommodityOrder(BcmAddApplyCommodityOrderReqBO commodityOrderReqBO) {
        ParamValidateUtils.validate(commodityOrderReqBO);

        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = BcmCommonBeanUtil.copyProperties(commodityOrderReqBO, BcmApplyCommodityOrderPO.class);
        Long applyOrderId = IdUtil.nextId();
        bcmApplyCommodityOrder.setId(IdUtil.nextId());
        bcmApplyCommodityOrder.setApplyOrderId(applyOrderId);
        String applyOrderCode = BcmPersonalCommodityConstant.ApplyOrderCodePrefix + DateUtil.format(new Date(), "yyyyMMddHHmmssSSS") + String.format("%03d", RandomUtil.randomLong(4L));
        bcmApplyCommodityOrder.setApplyOrderCode(applyOrderCode);
        bcmApplyCommodityOrder.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmApplyCommodityOrder.setCreateTime(new Date());
        bcmApplyCommodityOrder.setCreateUserId(commodityOrderReqBO.getUserId());
        bcmApplyCommodityOrder.setCreateUserName(commodityOrderReqBO.getName());
        commodityOrderMapper.insert(bcmApplyCommodityOrder);
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = BcmCommonBeanUtil.copyProperties(commodityOrderReqBO.getApplyCommodityOrderItem(), BcmApplyCommodityOrderItemPO.class);
        bcmApplyCommodityOrderItem.setId(IdUtil.nextId());
        Long applyOrderItemId = IdUtil.nextId();
        bcmApplyCommodityOrderItem.setApplyOrderItemId(applyOrderItemId);
        bcmApplyCommodityOrderItem.setApplyOrderId(applyOrderId);
        bcmApplyCommodityOrderItem.setCreateUserId(commodityOrderReqBO.getUserId());
        bcmApplyCommodityOrderItem.setCreateUserName(commodityOrderReqBO.getName());
        bcmApplyCommodityOrderItem.setCreateTime(new Date());
        bcmApplyCommodityOrderItem.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        commodityOrderItemMapper.insert(bcmApplyCommodityOrderItem);
        if (CollectionUtil.isNotEmpty(commodityOrderReqBO.getApplyCommodityOrderItem().getFileList())) {
            List<BcmFilePO> bcmFileList = BcmCommonBeanUtil.listCopyProperties(commodityOrderReqBO.getApplyCommodityOrderItem().getFileList(), BcmFilePO.class);
            bcmFileList.forEach(bcmFile -> {
                bcmFile.setId(IdUtil.nextId());
                bcmFile.setFileId(IdUtil.nextId() + "");
                bcmFile.setBusinessId(applyOrderItemId);
                bcmFile.setBusinessType(BcmPersonalCommonConstant.BusinessType.APPLY_ORDER_ITEM);
                bcmFile.setCreateTime(new Date());
                bcmFile.setCreateUserId(commodityOrderReqBO.getUserId());
                bcmFile.setCreateUserName(commodityOrderReqBO.getName());
                bcmFile.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            });
            fileMapper.insertBatch(bcmFileList);
        }
        BcmAddApplyCommodityOrderRspBO success = PerSonalRuUtil.success(BcmAddApplyCommodityOrderRspBO.class);
        success.setApplyOrderId(applyOrderId);
        return success;
    }
}
