package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmAddBatchApplyCommodityConfService;
import com.tydic.bcm.personal.commodity.bo.BcmAddBatchApplyCommodityConfReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmAddBatchApplyCommodityConfRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyOrderSelTimeLimitConfMapper;
import com.tydic.bcm.personal.po.BcmApplyOrderSelTimeLimitConfPO;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 类名： BcmAddApplyCommodityConfServiceImpl
 * 说明：上架申请单-新增选定时间设置实现
 *
 * @author： lishiqing
 * 时间： 2023/7/28 10:45
 */
@HTServiceImpl
public class BcmAddBatchApplyCommodityConfServiceImpl implements BcmAddBatchApplyCommodityConfService {

    @Autowired
    private BcmApplyOrderSelTimeLimitConfMapper bcmApplyOrderSelTimeLimitConfMapper;

    @Override
    public BcmAddBatchApplyCommodityConfRspBO addBatchApplyCommodityConf(BcmAddBatchApplyCommodityConfReqBO reqBO) {
        BcmAddBatchApplyCommodityConfRspBO rspBO = new BcmAddBatchApplyCommodityConfRspBO();
        // 参数校验
        verifyParam(reqBO);

        // 入参组装
        List<BcmApplyOrderSelTimeLimitConfPO> list = reqBO.getApplyCommodityConfList().stream().map(item -> {
            BcmApplyOrderSelTimeLimitConfPO insertPO = new BcmApplyOrderSelTimeLimitConfPO();
            insertPO.setId(IdUtil.nextId());
            insertPO.setCompanyId(item.getCompanyId());
            insertPO.setCompanyName(item.getCompanyName());
            insertPO.setSelectDayLimit(item.getSelectDayLimit());
            insertPO.setGlobalFlag(BcmPersonalCommodityConstant.GlobalFlag.NO);
            insertPO.setCreateUserId(reqBO.getCreateUserId());
            insertPO.setCreateUserName(reqBO.getCreateUserName());
            insertPO.setCreateTime(new Date());
            insertPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
            return insertPO;
        }).collect(Collectors.toList());

        // 插入数据
        int i = bcmApplyOrderSelTimeLimitConfMapper.insertBatch(list);
        if (i < 1) {
            throw new ZTBusinessException("采购用途新增失败");
        }

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmAddBatchApplyCommodityConfReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("新增选定时间设置入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getApplyCommodityConfList())) {
            throw new ZTBusinessException("新增选定时间设置入参新增对象集合【applyCommodityConfList】为空");
        }
}   }
