package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmDeleteApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmDeleteApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmDeleteApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 类名： BcmDeleteApplyCommodityOrderServiceImpl
 * 说明：上架申请单-删除实现
 *
 * @author： lishiqing
 * 时间： 2023/7/31 14:08
 */
@HTServiceImpl
public class BcmDeleteApplyCommodityOrderServiceImpl implements BcmDeleteApplyCommodityOrderService {

    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @Autowired
    private BcmApplyCommodityOrderItemMapper bcmApplyCommodityOrderItemMapper;

    @Autowired
    private BcmFileMapper bcmFileMapper;

    @Override
    public BcmDeleteApplyCommodityOrderRspBO deleteApplyCommodityOrder(BcmDeleteApplyCommodityOrderReqBO reqBO) {
        BcmDeleteApplyCommodityOrderRspBO rspBO = new BcmDeleteApplyCommodityOrderRspBO();

        // 参数校验
        verifyParam(reqBO);

        // 判断申请单是否存在
        BcmApplyCommodityOrderPO orderPO = bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (ObjectUtil.isEmpty(orderPO)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc("申请单不存在");
            return rspBO;
        }

        // 判断申请单是否为草稿状态
        if (!BcmPersonalApplyOrderStatusEnum.DRAFT.getStatus().equals(orderPO.getApplyOrderStatus())) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc("该申请单不处于草稿状态,不能删除");
            return rspBO;
        }

        // 根据主键删除bcm_apply_commodity_order数据
        BcmApplyCommodityOrderPO deleteOrderPo = new BcmApplyCommodityOrderPO();
        deleteOrderPo.setApplyOrderId(reqBO.getApplyOrderId());
        deleteOrderPo.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        bcmApplyCommodityOrderMapper.update(deleteOrderPo);

        // 根据申请单id删除bcm_apply_commodity_order_Item数据
        BcmApplyCommodityOrderItemPO  deleteOrderItemPO = new BcmApplyCommodityOrderItemPO();
        deleteOrderItemPO.setApplyOrderId(reqBO.getApplyOrderId());
        deleteOrderItemPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        bcmApplyCommodityOrderItemMapper.updateByOrderItemId(deleteOrderItemPO);

        // 根据申请单id删除bcm_file数据
        bcmFileMapper.deleteByBusinessId(reqBO.getApplyOrderId());

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmDeleteApplyCommodityOrderReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("上架申请单删除入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getApplyOrderId())) {
            throw new ZTBusinessException("上架申请单删除入参上架申请单ID【applyOrderId】为空");
        }
    }
}
