package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderPageListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderPageBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonStatus;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryApplyCommodityOrderPageListServiceImpl
 * 说明 上架申请单-列表查询（分页）实现
 * 时间 2023/7/31 14:25
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryApplyCommodityOrderPageListServiceImpl implements BcmQueryApplyCommodityOrderPageListService {

    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    /**
     * 列表查询（分页）实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryApplyCommodityOrderPageListRspBO queryApplyCommodityOrderPageList(BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = getBcmApplyCommodityOrderPO(reqBO);
        Page<BcmApplyCommodityOrderPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        List<BcmApplyCommodityOrderPO> list = bcmApplyCommodityOrderMapper.getListPage(bcmApplyCommodityOrderPO, page);
        return setRspBO(list,page);
    }

    /**
     * 出参组装
     * @param list
     * @param page
     * @return
     */
    private BcmQueryApplyCommodityOrderPageListRspBO setRspBO(List<BcmApplyCommodityOrderPO> list,Page<BcmApplyCommodityOrderPO> page){
        BcmQueryApplyCommodityOrderPageListRspBO rspBO = PerSonalRuUtil.success(BcmQueryApplyCommodityOrderPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(PerSonalRuUtil.jsl(list, BcmApplyCommodityOrderPageBO.class));
        if(CollectionUtils.isNotEmpty(rspBO.getRows())){
            //翻译
            for (BcmApplyCommodityOrderPageBO bo: rspBO.getRows()){
                bo.setIsCustomizedFlagStr(BcmPersonalCommonStatus.getStatusDesc(bo.getIsCustomizedFlag()));
                bo.setApplyOrderStatusStr(BcmPersonalApplyOrderStatusEnum.getStatusDesc(bo.getApplyOrderStatus()));
            }
        }
        return rspBO;
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmApplyCommodityOrderPO getBcmApplyCommodityOrderPO(BcmQueryApplyCommodityOrderPageListReqBO reqBO){
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = PerSonalRuUtil.js(reqBO,BcmApplyCommodityOrderPO.class);
        bcmApplyCommodityOrderPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return bcmApplyCommodityOrderPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQueryApplyCommodityOrderPageListReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getSumFlag() == null){
            throw new ZTBusinessException("参数是否查询汇总数据不能为null");
        }

    }
}
