package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.commodity.api.BcmQueryPendingAuditApplyCommodityOrderPageListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderPageBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryPendingAuditApplyCommodityOrderPageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryPendingAuditApplyCommodityOrderPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPagePO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： BcmQueryPendingAuditApplyCommodityOrderPageListService
 * 说明：上架申请单-待审批列表查询（分页）实现
 *
 * @author： lishiqing
 * 时间： 2023/8/1 9:55
 */
@HTServiceImpl
public class BcmQueryPendingAuditApplyCommodityOrderPageListServiceImpl implements BcmQueryPendingAuditApplyCommodityOrderPageListService {

    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyMapper bcmApplyCommodityOrderSupplierReplyMapper;

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @Override
    public BcmQueryPendingAuditApplyCommodityOrderPageListRspBO queryPendingAuditApplyCommodityOrderPageList(BcmQueryPendingAuditApplyCommodityOrderPageListReqBO reqBO) {
        BcmQueryPendingAuditApplyCommodityOrderPageListRspBO rspBO = new BcmQueryPendingAuditApplyCommodityOrderPageListRspBO();

        // 参数校验
        verifyParam(reqBO);

        // 入参组装
        Page<BcmApplyCommodityOrderPagePO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        BcmApplyCommodityOrderPagePO po = JSONObject.parseObject(JSON.toJSONString(reqBO), BcmApplyCommodityOrderPagePO.class);
        List<BcmApplyCommodityOrderPagePO> poList = bcmApplyCommodityOrderMapper.queryPendingAuditApplyCommodityOrderPageList(po, page);

        // 分页参数组装
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(poList) ?
                JSONObject.parseArray(JSONObject.toJSONString(poList), BcmApplyCommodityOrderPageBO.class) : new ArrayList<>());

        // 如果结果为空直接返回
        if (ObjectUtil.isEmpty(rspBO.getRows())) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }
        // 出参组装
        setRspBO(reqBO, rspBO);


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 出参组装
     *
     * @param reqBO
     * @param rspBO
     */
    private void setRspBO(BcmQueryPendingAuditApplyCommodityOrderPageListReqBO reqBO, BcmQueryPendingAuditApplyCommodityOrderPageListRspBO rspBO) {
        rspBO.getRows().forEach(item -> {
            // 判断是否查询汇总数据
            if (BcmPersonalCommonConstant.YesOrNo.YES.equals(reqBO.getSumFlag())) {
                // 统计回应商家数量
                BcmApplyCommodityOrderSupplierReplyPO qryReplySupplierNumPO = new BcmApplyCommodityOrderSupplierReplyPO();
                qryReplySupplierNumPO.setApplyOrderId(item.getApplyOrderId());
                qryReplySupplierNumPO.setGroupByName("SUPPLIER_ID");
                qryReplySupplierNumPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
                Integer replySupplierNum = bcmApplyCommodityOrderSupplierReplyMapper.count(qryReplySupplierNumPO);
                item.setReplySupplierNum(replySupplierNum);

                // 统计选定商家数量
                BcmApplyCommodityOrderSupplierReplyPO selectReplySupplierNumPO = new BcmApplyCommodityOrderSupplierReplyPO();
                selectReplySupplierNumPO.setApplyOrderId(item.getApplyOrderId());
                selectReplySupplierNumPO.setGroupByName("SUPPLIER_ID");
                selectReplySupplierNumPO.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
                selectReplySupplierNumPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
                Integer selectSupplierNum = bcmApplyCommodityOrderSupplierReplyMapper.count(selectReplySupplierNumPO);
                item.setSelectSupplierNum(selectSupplierNum);

                // 统计回应商品数量
                BcmApplyCommodityOrderSupplierReplyItemPO qryReplyCommodityNumPO = new BcmApplyCommodityOrderSupplierReplyItemPO();
                qryReplyCommodityNumPO.setApplyOrderId(item.getApplyOrderId());
                qryReplyCommodityNumPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
                Integer replyCommodityNum = bcmApplyCommodityOrderSupplierReplyItemMapper.count(qryReplyCommodityNumPO);
                item.setReplyCommodityNum(replyCommodityNum);

                // 统计选定商品数量
                BcmApplyCommodityOrderSupplierReplyItemPO selectReplyCommodityNumPO = new BcmApplyCommodityOrderSupplierReplyItemPO();
                selectReplyCommodityNumPO.setApplyOrderId(item.getApplyOrderId());
                selectReplySupplierNumPO.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
                selectReplyCommodityNumPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
                Integer selectCommodityNum = bcmApplyCommodityOrderSupplierReplyItemMapper.count(selectReplyCommodityNumPO);
                item.setSelectCommodityNum(selectCommodityNum);
            }

            // 翻译
            if (ObjectUtil.isNotEmpty(item.getApplyOrderStatus())) {
                item.setApplyOrderStatusStr(BcmPersonalApplyOrderStatusEnum.getStatusDesc(item.getApplyOrderStatus()));
            }
            if (ObjectUtil.isNotEmpty(item.getIsCustomizedFlag())) {
                item.setIsCustomizedFlagStr(BcmPersonalCommonConstant.YesOrNo.YesOrNoMap.get(item.getIsCustomizedFlag()));
            }
        });
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmQueryPendingAuditApplyCommodityOrderPageListReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("待审批列表查询（分页）入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getSumFlag())) {
            throw new ZTBusinessException("待审批列表查询（分页）是否查询汇总数据【sumFlag】入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getFlowType())) {
            throw new ZTBusinessException("待审批列表查询（分页）流程类型【flowType】入参为空");
        }
    }
}
