package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmUpdateApplyOrderSelectTimeLimitConfService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateApplyOrderSelectTimeLimitConfReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateApplyOrderSelectTimeLimitConfRspBO;
import com.tydic.bcm.personal.dao.BcmApplyOrderSelTimeLimitConfMapper;
import com.tydic.bcm.personal.po.BcmApplyOrderSelTimeLimitConfPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.Date;


/**
 * 标题 BcmUpdateApplyOrderSelectTimeLimitConfServiceImpl
 * 说明 上架申请单-修改选定时限配置实现
 * 时间 2023/7/28 09:56
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmUpdateApplyOrderSelectTimeLimitConfServiceImpl implements BcmUpdateApplyOrderSelectTimeLimitConfService {

    @Autowired
    private BcmApplyOrderSelTimeLimitConfMapper bcmApplyOrderSelTimeLimitConfMapper;

    /**
     * 修改选定时限配置实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmUpdateApplyOrderSelectTimeLimitConfRspBO updateApplyOrderSelectTimeLimitConf(BcmUpdateApplyOrderSelectTimeLimitConfReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmApplyOrderSelTimeLimitConfPO bcmApplyOrderSelTimeLimitConfPO = getBcmApplyOrderSelTimeLimitConfPO(reqBO);
        bcmApplyOrderSelTimeLimitConfMapper.updateById(bcmApplyOrderSelTimeLimitConfPO);
        return PerSonalRuUtil.success(BcmUpdateApplyOrderSelectTimeLimitConfRspBO.class);
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmApplyOrderSelTimeLimitConfPO getBcmApplyOrderSelTimeLimitConfPO(BcmUpdateApplyOrderSelectTimeLimitConfReqBO reqBO){
        BcmApplyOrderSelTimeLimitConfPO bcmApplyOrderSelTimeLimitConfPO = PerSonalRuUtil.js(reqBO, BcmApplyOrderSelTimeLimitConfPO.class);
        bcmApplyOrderSelTimeLimitConfPO.setUpdateTime(new Date());
        bcmApplyOrderSelTimeLimitConfPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyOrderSelTimeLimitConfPO.setUpdateUserName(reqBO.getUserName());
        return bcmApplyOrderSelTimeLimitConfPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmUpdateApplyOrderSelectTimeLimitConfReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getId() == null){
            throw new ZTBusinessException("参数id不能为null");
        }
        if(reqBO.getCompanyId() == null){
            throw new ZTBusinessException("参数应用单位Id不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getCompanyName())){
            throw new ZTBusinessException("参数应用单位名称不能为null");
        }
        if(reqBO.getSelectDayLimit() == null){
            throw new ZTBusinessException("参数选定期限不能为null");
        }

    }
}
