package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmIncrementSyncBasicProjectService;
import com.tydic.bcm.personal.common.bo.*;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBasicProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBasicProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBasicProjectInfoPO;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题 BcmIncrementSyncBasicProjectServiceImpl
 * 说明 项目基本信息-项目基本信息增量同步实现
 * 时间 2023/8/1 15:44
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmIncrementSyncBasicProjectServiceImpl implements BcmIncrementSyncBasicProjectService {

    @Autowired
    private BcmBasicProjectInfoMapper bcmBasicProjectInfoMapper;

    @Override
    public BcmIncrementSyncBasicProjectRspBO incrementSyncBasicProject(BcmIncrementSyncBasicProjectReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //增量同步
        incSyncBasicProject(reqBO);
        return PerSonalRuUtil.success(BcmIncrementSyncBasicProjectRspBO.class);
    }

    /**
     * 增量同步
     * @param reqBO
     */
    private void incSyncBasicProject(BcmIncrementSyncBasicProjectReqBO reqBO){
        List<BcmBasicProjectInfoPO> addList = new ArrayList<>(reqBO.getChangeList().size());
        List<BcmBasicProjectInfoPO> updateList = new ArrayList<>(reqBO.getChangeList().size());
        List<String> projectList = getExistProjectCode(reqBO);
        Date now = new Date();
        for (BcmBasicProjectInfoBO bo:reqBO.getChangeList()) {
            BcmBasicProjectInfoPO po ;
            //新增
            if(!projectList.contains(bo.getProjectCode())){
                po = JSONObject.parseObject(JSONObject.toJSONString(bo),BcmBasicProjectInfoPO.class);
                po.setId(IdUtil.nextId());
                po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                if(po.getCreateTime() == null){
                    po.setCreateTime(now);
                }
                if(po.getUpdateTime() == null){
                    po.setUpdateTime(now);
                }
                addList.add(po);
            } else{
                //修改
                po = JSONObject.parseObject(JSONObject.toJSONString(bo),BcmBasicProjectInfoPO.class);
                if(po.getUpdateTime() == null){
                    po.setUpdateTime(now);
                }
                updateList.add(po);
            }
        }
        if(CollectionUtils.isEmpty(addList)){
            bcmBasicProjectInfoMapper.insertBatch(addList);
        }
        if(CollectionUtils.isEmpty(updateList)){
            bcmBasicProjectInfoMapper.updateBatch(updateList);
        }
    }

    /**
     * 获取存在的项目code
     */
    private List<String> getExistProjectCode(BcmIncrementSyncBasicProjectReqBO reqBO){
        BcmQueryBasicProjectInfoPO bcmQueryBasicProjectInfoPO = new BcmQueryBasicProjectInfoPO();
        bcmQueryBasicProjectInfoPO.setProjectCodeList(reqBO.getChangeList().stream().map(BcmBasicProjectInfoBO::getProjectCode).collect(Collectors.toList()));
        List<BcmBasicProjectInfoPO> list = bcmBasicProjectInfoMapper.getList(bcmQueryBasicProjectInfoPO);
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        return list.stream().map(BcmBasicProjectInfoPO::getProjectCode).collect(Collectors.toList());
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmIncrementSyncBasicProjectReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getChangeList())){
            throw new ZTBusinessException("入参成本信息list不能为null");
        }
        for (BcmBasicProjectInfoBO bo:reqBO.getChangeList()) {
            if(StringUtils.isEmpty(bo.getProjectCode())){
                throw new ZTBusinessException("入参项目编码不能为null");
            }
            if(StringUtils.isEmpty(bo.getProjectName())){
                throw new ZTBusinessException("入参项目名称不能为null");
            }
            if (StringUtils.isEmpty(bo.getProOrgCode())){
                throw new ZTBusinessException("入参采购机构编号不能为null");
            }
            if(StringUtils.isEmpty(bo.getProOrgName())){
                throw new ZTBusinessException("入参采购机构名称不能为null");
            }
            if(bo.getBudgetMoney() == null){
                throw new ZTBusinessException("入参预算金额不能为null");
            }
            if(bo.getStatus() == null){
                throw new ZTBusinessException("入参状态不能为null");
            }
        }
    }
}
