package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryCostPageListService;
import com.tydic.bcm.personal.common.bo.BcmCostInfoBO;
import com.tydic.bcm.personal.common.bo.BcmQueryCostPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryCostPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmCostInfoMapper;
import com.tydic.bcm.personal.po.BcmCostInfoPO;
import com.tydic.bcm.personal.po.BcmQueryCostInfoPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题 BcmQueryCostPageListServiceImpl
 * 说明 成本中心查询-成本中心列表查询（分页）实现
 * 时间 2023/7/20 15:48
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryCostPageListServiceImpl implements BcmQueryCostPageListService {

    @Autowired
    private BcmCostInfoMapper bcmCostInfoMapper;

    /**
     * 成本中心列表查询（分页）
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryCostPageListRspBO queryCostPageList(BcmQueryCostPageListReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmQueryCostInfoPO bcmQueryCostInfoPO = getBcmQueryCostInfoPO(reqBO);
        Page<BcmCostInfoPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        List<BcmCostInfoPO> list = bcmCostInfoMapper.getListPage(bcmQueryCostInfoPO, page);
        return setRspBO(list,page);
    }


    /**
     * 出参组装
     * @param list
     * @param page
     * @return
     */
    private BcmQueryCostPageListRspBO setRspBO(List<BcmCostInfoPO> list,Page<BcmCostInfoPO> page){
        BcmQueryCostPageListRspBO rspBO = PerSonalRuUtil.success(BcmQueryCostPageListRspBO.class);
        rspBO.setRows(PerSonalRuUtil.jsl(list,BcmCostInfoBO.class));
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        if(!CollectionUtils.isEmpty(rspBO.getRows())){
            for (BcmCostInfoBO bo: rspBO.getRows()){
                if(BcmPersonalCommonConstant.Status.DISABLE.equals(bo.getStatus())){
                    bo.setStatusStr(BcmPersonalCommonConstant.Status.DISABLE_STR);
                } else if (BcmPersonalCommonConstant.Status.ENABLE.equals(bo.getStatus())) {
                    bo.setStatusStr(BcmPersonalCommonConstant.Status.ENABLE_STR);
                }
            }
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        return rspBO;
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmQueryCostInfoPO getBcmQueryCostInfoPO(BcmQueryCostPageListReqBO reqBO){
        BcmQueryCostInfoPO bcmQueryCostInfoPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO),BcmQueryCostInfoPO.class);
        bcmQueryCostInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryCostInfoPO.setOrderBy("UPDATE_TIME DESC");
        return bcmQueryCostInfoPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQueryCostPageListReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
    }
}
