package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmSuggestedManagementInfoMapper;
import com.tydic.bcm.personal.common.api.BcmQuerySuggestedManagementInfoPageListService;
import com.tydic.bcm.personal.common.bo.BcmQuerySuggestedManagementInfoPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQuerySuggestedManagementInfoPageListRspBO;
import com.tydic.bcm.personal.common.bo.BcmSuggestedManagementInfoBO;
import com.tydic.bcm.personal.po.BcmSuggestedManagementInfoPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题 BcmQuerySuggestedManagementInfoPageListServiceImpl
 * 说明 我的建议-建议列表查询(分页)实现
 * 时间 2023/7/24 10:25
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQuerySuggestedManagementInfoPageListServiceImpl implements BcmQuerySuggestedManagementInfoPageListService {

    @Autowired
    private BcmSuggestedManagementInfoMapper bcmSuggestedManagementInfoMapper;

    /**
     * 建议列表查询(分页)
     * @param reqBO
     * @return
     */
    @Override
    public BcmQuerySuggestedManagementInfoPageListRspBO querySuggestedManagementInfoPageList(BcmQuerySuggestedManagementInfoPageListReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmSuggestedManagementInfoPO bcmSuggestedManagementInfoPO = getBcmSuggestedManagementInfoPO(reqBO);
        Page<BcmSuggestedManagementInfoPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        List<BcmSuggestedManagementInfoPO> list = bcmSuggestedManagementInfoMapper.getListPage(bcmSuggestedManagementInfoPO, page);
        return setRspBO(list,page);
    }

    /**
     * 出参组装
     * @return
     */
    private BcmQuerySuggestedManagementInfoPageListRspBO setRspBO(List<BcmSuggestedManagementInfoPO> list, Page<BcmSuggestedManagementInfoPO> page){
        BcmQuerySuggestedManagementInfoPageListRspBO rspBO = PerSonalRuUtil.success(BcmQuerySuggestedManagementInfoPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(PerSonalRuUtil.jsl(list,BcmSuggestedManagementInfoBO.class));
        if(!CollectionUtils.isEmpty(rspBO.getRows())){
            for (BcmSuggestedManagementInfoBO bo: rspBO.getRows()){
                //匿名设置
                if(BcmPersonalCommonConstant.IsAnonymous.YES.equals(bo.getIsAnonymous())){
                    bo.setSuggestedUserId(null);
                    bo.setSuggestedUserName("***");
                    bo.setSuggestedOrgId(null);
                    bo.setSuggestedOrgName("***");
                    bo.setSuggestedCompanyId(null);
                    bo.setSuggestedCompanyName("***");
                }
                //栏目翻译
                if(BcmPersonalCommonConstant.SuggestedColumn.BUSINESS_EXCHANGE.toString().equals(bo.getSuggestedColumn())){
                    bo.setSuggestedColumnStr(BcmPersonalCommonConstant.SuggestedColumn.BUSINESS_EXCHANGE_STR);
                } else if(BcmPersonalCommonConstant.SuggestedColumn.PROBLEM_FEEDBACK.toString().equals(bo.getSuggestedColumn())){
                    bo.setSuggestedColumnStr(BcmPersonalCommonConstant.SuggestedColumn.PROBLEM_FEEDBACK_STR);
                }else if(BcmPersonalCommonConstant.SuggestedColumn.SYSTEM_SUGGESTION.toString().equals(bo.getSuggestedColumn())){
                    bo.setSuggestedColumnStr(BcmPersonalCommonConstant.SuggestedColumn.SYSTEM_SUGGESTION_STR);
                }else if(BcmPersonalCommonConstant.SuggestedColumn.VIOLATION_FEEDBACK.toString().equals(bo.getSuggestedColumn())){
                    bo.setSuggestedColumnStr(BcmPersonalCommonConstant.SuggestedColumn.VIOLATION_FEEDBACK_STR);
                }
            }
        }
        return rspBO;
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmSuggestedManagementInfoPO getBcmSuggestedManagementInfoPO(BcmQuerySuggestedManagementInfoPageListReqBO reqBO){
        BcmSuggestedManagementInfoPO bcmSuggestedManagementInfoPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO),BcmSuggestedManagementInfoPO.class);
        bcmSuggestedManagementInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmSuggestedManagementInfoPO.setOrderBy("SUGGESTED_TIME DESC");
        return bcmSuggestedManagementInfoPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQuerySuggestedManagementInfoPageListReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
    }
}
