package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmSubmitDealOpinionService;
import com.tydic.bcm.personal.common.bo.BcmSubmitDealOpinionReqBO;
import com.tydic.bcm.personal.common.bo.BcmSubmitDealOpinionRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmSuggestedManagementInfoMapper;
import com.tydic.bcm.personal.po.BcmSuggestedManagementInfoPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * 标题 BcmSubmitDealOpinionServiceImpl
 * 说明 建议管理-提交处理意见实现
 * 时间 2023/7/24 14:40
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmSubmitDealOpinionServiceImpl implements BcmSubmitDealOpinionService {

    @Autowired
    private BcmSuggestedManagementInfoMapper bcmSuggestedManagementInfoMapper;

    /**
     * 提交处理意见
     * @param reqBO
     * @return
     */
    @Override
    public BcmSubmitDealOpinionRspBO submitDealOpinion(BcmSubmitDealOpinionReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //处理意见提交
        subDealOpinion(reqBO);
        return PerSonalRuUtil.success(BcmSubmitDealOpinionRspBO.class);
    }

    /**
     * 处理意见提交
     * @param reqBO
     */
    private void subDealOpinion(BcmSubmitDealOpinionReqBO reqBO){
        BcmSuggestedManagementInfoPO set = JSONObject.parseObject(JSONObject.toJSONString(reqBO),BcmSuggestedManagementInfoPO.class);
        set.setDealStatus(BcmPersonalCommonConstant.DealStatus.PROCESSED);
        BcmSuggestedManagementInfoPO where = new BcmSuggestedManagementInfoPO();
        where.setSuggestedId(reqBO.getSuggestedId());
        bcmSuggestedManagementInfoMapper.updateBy(set,where);
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmSubmitDealOpinionReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getSuggestedId() == null){
            throw new ZTBusinessException("建议单id不能为null");
        }
        if(reqBO.getDealUserId() == null){
            throw new ZTBusinessException("处理人id不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getDealUserName())){
            throw new ZTBusinessException("处理人名称不能为null");
        }
        if(reqBO.getDealTime() == null){
            throw new ZTBusinessException("处理时间不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getDealOpinion())){
            throw new ZTBusinessException("处理意见不能为null");
        }
    }
}
