package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/7/28 17:32
 * 上架申请单审核状态
 */
public enum BcmPersonalApplyOrderStatusEnum {

    /**
     * 上架申请单状态：
     * 1：草稿；2：申请审批中；3：应答中；4：选定中；5：已选定
     * 6：结果审批中；7：已完成；8：已终止
     */
    DRAFT(1, "草稿"),
    IN_APPROVAL(2, "审批中"),
    IN_REPLY(3, "应答中"),
    IN_SELECT(4, "选定中"),
    SELECTED(5, "已选定"),
    IN_RESULT_APPROVAL(6, "结果审批中"),
    FINISH(7, "已完成"),
    TERMINATION(8, "已终止"),
    ;


    @Getter
    private final Integer status;

    @Getter
    private final String desc;

    BcmPersonalApplyOrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }


    public static String getStatusDesc(Integer status) {
        BcmPersonalApplyOrderStatusEnum[] values = BcmPersonalApplyOrderStatusEnum.values();
        for (BcmPersonalApplyOrderStatusEnum applyOrderStatus : values) {
            if (applyOrderStatus.getStatus().equals(status)) {
                return applyOrderStatus.getDesc();
            }
        }
        return null;
    }
}
