package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmPurchasePurposeConfigPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 类名： BcmPurchasePurposeConfigMapper
 * 说明：采购用途配置Mapper
 *
 * @author： lishiqing
 * 时间： 2023/7/21 10:35
 */
@Mapper
@Repository
public interface BcmPurchasePurposeConfigMapper {
    /**
     * 根据条件分页查询列表数据
     * @param bcmPurchasePurposeConfigPO 参数对象
     * @param page  分页参数
     * @return List<BcmPurchasePurposeConfigPO> 结果对象
     */
    List<BcmPurchasePurposeConfigPO> getPageList(BcmPurchasePurposeConfigPO bcmPurchasePurposeConfigPO, Page<BcmPurchasePurposeConfigPO> page);

    /**
     * 插入单条数据
     * @param bcmPurchasePurposeConfigPO 参数对象
     * @return int 影响数量
     */
    int insert(BcmPurchasePurposeConfigPO bcmPurchasePurposeConfigPO);

    /**
     * 根据主键更新数据
     * @param bcmPurchasePurposeConfigPO 参数对象
     * @return int 影响数量
     */
    int updateById(BcmPurchasePurposeConfigPO bcmPurchasePurposeConfigPO);

    /**
     * 根据条件查询列表数据
     *
     * @param bcmPurchasePurposeConfigPO 参数对象
     * @return List<BcmPurchasePurposeConfigPO> 结果对象
     */
    List<BcmPurchasePurposeConfigPO> getList(BcmPurchasePurposeConfigPO bcmPurchasePurposeConfigPO);
}
