package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题 BcmApplyCommodityOrderPagePO
 * 说明
 * 时间 2023/7/31 14:11
 *
 * @author lishiqing
 */
@Data
public class BcmApplyCommodityOrderPagePO implements Serializable {
    private static final long serialVersionUID = -8657547661357251243L;
    /**
     * 任务ID
     */
    private Long taskId;
    /**
     * 申请单id
     */
    private Long applyOrderId;

    /**
     * 上架申请单编码
     */
    private String applyOrderCode;

    /**
     * 上架申请单名称
     */
    private String applyOrderName;

    /**
     * 上架申请单状态
     * 1：草稿；2：申请审批中；3：应答中；4：选定中；5：已选定
     * 6：结果审批中；7：已完成；8：已终止
     */
    private Integer applyOrderStatus;

    /**
     * 上架申请单状态翻译
     */
    private String applyOrderStatusStr;


    /**
     * 发起人机构id
     */
    private Long applyUserOrgId;
    /**
     * 发起人机构名称
     */
    private String applyUserOrgName;

    /**
     * 采购单位id
     */
    private Long purCompanyId;
    /**
     * 采购单位名称
     */
    private String purCompanyName;
    /**
     * 联系电话
     */
    private String applyUserPhone;

    /**
     * 发起人id
     */
    private Long applyUserId;

    /**
     * 发起人名称
     */
    private String applyUserName;
    /**
     * 发起人公司id
     */
    private Long applyUserCompanyId;

    /**
     * 发起人公司名称
     */
    private String applyUserCompanyName;

    /**
     * 是否为定制商品0是1否
     */
    private Integer isCustomizedFlag;

    /**
     * 是否为定制商品翻译
     */
    private String isCustomizedFlagStr;

    /**
     * 应答期限（日）
     */
    private Integer replyDayLimit;

    /**
     * 应答截止日期
     */
    private Date replyDeadlineDate;

    /**
     * 挂接商品截止日期
     */
    private Date hitchDeadlineDate;


    /**
     * 选定截止日期
     */
    private Date selectDeadlineDate;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 回应商家数量
     */
    private Integer replySupplierNum;

    /**
     * 选定上架数量
     */
    private Integer selectSupplierNum;

    /**
     * 回应商品数量
     */
    private Integer replyCommodityNum;

    /**
     * 选定商品数量
     */
    private Integer selectCommodityNum;

    /**
     * 上架申请单审批通过时间
     */
    private Date  applyApprovePassTime;

    /**
     * 选定审核通过时间
     */
    private Date selectApprovePassTime;

    /**
     * 提交开始时间
     */
    private Date createStartTime;

    /**
     * 提交结束时间
     */
    private Date createEndTime;

    /**
     * 截止应答开始时间
     */
    private Date replyDeadlineStartDate;

    /**
     * 截止应答结束时间
     */
    private Date replyDeadlineEndDate;

    /**
     * 任务状态
     * 任务状态1待审核2已通过3已驳回4已取消
     */
    private List<Integer> taskStatus;

    /**
     * 是否查询汇总数据 0是1否
     */
    private Integer sumFlag;

    /**
     * 流程类型：
     * 1：上架申请审批
     * 2：上架申请选定结果审批
     */
    private Integer flowType;

    /**
     * 待审人ID
     */
    private Long pendingAuditUserId;

    /**
     * 审批人ID
     */
    private Long auditUserId;
}
