package com.tydic.bcm.personal.settle.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalSettleConstant;
import com.tydic.bcm.personal.dao.BcmBondDeductInfoMapper;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.settle.api.BcmQueryDetailBondDeductService;
import com.tydic.bcm.personal.settle.bo.BcmAddBondDeductRspBO;
import com.tydic.bcm.personal.settle.bo.BcmQueryDetailBondDeductReqBO;
import com.tydic.bcm.personal.settle.bo.BcmQueryDetailBondDeductRspBO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题 BcmQueryDetailBondDeductServiceImpl
 * 说明 保证金管理-保证金扣除申请单详情查询实现
 * 时间 2023/7/25 15:25
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryDetailBondDeductServiceImpl implements BcmQueryDetailBondDeductService {

    @Autowired
    private BcmBondDeductInfoMapper bcmBondDeductInfoMapper;

    @Override
    public BcmQueryDetailBondDeductRspBO queryDetailBondDeduct(BcmQueryDetailBondDeductReqBO reqBO) {
        verifyParam(reqBO);
        BcmBondDeductInfoPO bcmBondDeductInfoPO = new BcmBondDeductInfoPO();
        bcmBondDeductInfoPO.setId(reqBO.getId());
        BcmBondDeductInfoPO modelBy = bcmBondDeductInfoMapper.getModelBy(bcmBondDeductInfoPO);
        return setRspBO(modelBy);
    }

    /**
     * 出参组装
     * @param bcmBondDeductInfoPO
     * @return
     */
    private BcmQueryDetailBondDeductRspBO setRspBO(BcmBondDeductInfoPO bcmBondDeductInfoPO){
        BcmQueryDetailBondDeductRspBO rspBO =  PerSonalRuUtil.js(bcmBondDeductInfoPO,BcmQueryDetailBondDeductRspBO.class);
        //状态翻译
        if(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMING.equals(rspBO.getDocStatus())){
            rspBO.setDocStatusStr(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMING_STR);
        }else if(BcmPersonalSettleConstant.BondDeductStatus.DECLINED.equals(rspBO.getDocStatus())){
            rspBO.setDocStatusStr(BcmPersonalSettleConstant.BondDeductStatus.DECLINED_STR);
        }else if(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMED.equals(rspBO.getDocStatus())){
            rspBO.setDocStatusStr(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMED_STR);
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        return rspBO;
    }
    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmQueryDetailBondDeductReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (reqBO.getId() == null) {
            throw new ZTBusinessException("入参id不能为null");
        }
    }
}
