/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderPageListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderPageBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonStatus;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderPageListService"})
public class BcmQueryApplyCommodityOrderPageListServiceImpl
implements BcmQueryApplyCommodityOrderPageListService {
    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @PostMapping(value={"queryApplyCommodityOrderPageList"})
    public BcmQueryApplyCommodityOrderPageListRspBO queryApplyCommodityOrderPageList(@RequestBody BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = this.getBcmApplyCommodityOrderPO(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmApplyCommodityOrderPO> list = this.bcmApplyCommodityOrderMapper.getListPage(bcmApplyCommodityOrderPO, (Page<BcmApplyCommodityOrderPO>)page);
        return this.setRspBO(list, (Page<BcmApplyCommodityOrderPO>)page);
    }

    private BcmQueryApplyCommodityOrderPageListRspBO setRspBO(List<BcmApplyCommodityOrderPO> list, Page<BcmApplyCommodityOrderPO> page) {
        BcmQueryApplyCommodityOrderPageListRspBO rspBO = PerSonalRuUtil.success(BcmQueryApplyCommodityOrderPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(PerSonalRuUtil.jsl(list, BcmApplyCommodityOrderPageBO.class));
        if (CollectionUtils.isNotEmpty((Collection)rspBO.getRows())) {
            for (BcmApplyCommodityOrderPageBO bo : rspBO.getRows()) {
                bo.setIsCustomizedFlagStr(BcmPersonalCommonStatus.getStatusDesc(bo.getIsCustomizedFlag()));
                bo.setApplyOrderStatusStr(BcmPersonalApplyOrderStatusEnum.getStatusDesc(bo.getApplyOrderStatus()));
            }
        }
        return rspBO;
    }

    private BcmApplyCommodityOrderPO getBcmApplyCommodityOrderPO(BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = PerSonalRuUtil.js(reqBO, BcmApplyCommodityOrderPO.class);
        bcmApplyCommodityOrderPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return bcmApplyCommodityOrderPO;
    }

    private void verifyParam(BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getSumFlag() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u662f\u5426\u67e5\u8be2\u6c47\u603b\u6570\u636e\u4e0d\u80fd\u4e3anull");
        }
    }
}

