/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.bcm.personal.common.api.BcmApproveApplyOrderService;
import com.tydic.bcm.personal.common.bo.BcmApproveApplyOrderRspBO;
import com.tydic.bcm.personal.common.bo.BcmFlowInstanceBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmApproveApplyOrderService"})
public class BcmApproveApplyOrderServiceImpl
implements BcmApproveApplyOrderService {
    private final BcmFlowInstanceMapper flowInstanceMapper;
    private final BcmFlowTaskMapper flowTaskMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"approveApplyOrder"})
    public BcmApproveApplyOrderRspBO approveApplyOrder(@RequestBody BcmFlowInstanceBO bcmFlowInstance) {
        ParamValidateUtils.validate(bcmFlowInstance);
        BcmFlowInstancePO newflowInstance = BcmCommonBeanUtil.copyProperties(bcmFlowInstance, BcmFlowInstancePO.class);
        BcmFlowInstancePO existFlowInstance = this.flowInstanceMapper.queryByFlowInstanceId(newflowInstance.getFlowInstId());
        if (existFlowInstance != null) {
            newflowInstance.setId(existFlowInstance.getId());
            this.flowInstanceMapper.update(newflowInstance);
        } else {
            newflowInstance.setId(IdUtil.nextId());
            newflowInstance.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            this.flowInstanceMapper.insert(newflowInstance);
        }
        if (CollectionUtil.isNotEmpty((Collection)bcmFlowInstance.getBcmFlowTaskList())) {
            List<BcmFlowTaskPO> bcmFlowTaskList = BcmCommonBeanUtil.listCopyProperties(bcmFlowInstance.getBcmFlowTaskList(), BcmFlowTaskPO.class);
            ArrayList<BcmFlowTaskPO> needSaveFlowTaskList = new ArrayList<BcmFlowTaskPO>();
            bcmFlowTaskList.forEach(bcmFlowTaskPO -> {
                BcmFlowTaskPO queryFlowTask = this.flowTaskMapper.queryByTaskId(bcmFlowTaskPO.getTaskId());
                if (queryFlowTask != null) {
                    bcmFlowTaskPO.setId(queryFlowTask.getId());
                    this.flowTaskMapper.update((BcmFlowTaskPO)bcmFlowTaskPO);
                } else {
                    bcmFlowTaskPO.setId(IdUtil.nextId());
                    bcmFlowTaskPO.setFlowInstId(bcmFlowInstance.getFlowInstId());
                    bcmFlowTaskPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                    needSaveFlowTaskList.add((BcmFlowTaskPO)bcmFlowTaskPO);
                }
            });
            if (CollectionUtil.isNotEmpty(needSaveFlowTaskList)) {
                this.flowTaskMapper.insertBatch(needSaveFlowTaskList);
            }
        }
        return PerSonalRuUtil.success(BcmApproveApplyOrderRspBO.class);
    }

    public BcmApproveApplyOrderServiceImpl(BcmFlowInstanceMapper flowInstanceMapper, BcmFlowTaskMapper flowTaskMapper) {
        this.flowInstanceMapper = flowInstanceMapper;
        this.flowTaskMapper = flowTaskMapper;
    }
}

