/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmFullSyncCostService;
import com.tydic.bcm.personal.common.bo.BcmCostInfoBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncCostReqBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncCostRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmCostInfoMapper;
import com.tydic.bcm.personal.po.BcmCostInfoPO;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmFullSyncCostService"})
public class BcmFullSyncCostServiceImpl
implements BcmFullSyncCostService {
    @Autowired
    private BcmCostInfoMapper bcmCostInfoMapper;

    @PostMapping(value={"fullSyncCost"})
    public BcmFullSyncCostRspBO fullSyncCost(@RequestBody BcmFullSyncCostReqBO reqBO) {
        this.verifyParam(reqBO);
        List<BcmCostInfoPO> bcmCostInfoPOS = this.getCostInfoPOList(reqBO);
        this.bcmCostInfoMapper.insertBatch(bcmCostInfoPOS);
        return PerSonalRuUtil.success(BcmFullSyncCostRspBO.class);
    }

    private List<BcmCostInfoPO> getCostInfoPOList(BcmFullSyncCostReqBO reqBO) {
        ArrayList<BcmCostInfoPO> bcmCostInfoPOS = new ArrayList<BcmCostInfoPO>();
        Date now = new Date();
        for (BcmCostInfoBO bo : reqBO.getCostList()) {
            BcmCostInfoPO po = (BcmCostInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), BcmCostInfoPO.class);
            po.setId(IdUtil.nextId());
            po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            if (po.getCreateTime() == null) {
                po.setCreateTime(now);
            }
            if (po.getUpdateTime() == null) {
                po.setUpdateTime(now);
            }
            bcmCostInfoPOS.add(po);
        }
        return bcmCostInfoPOS;
    }

    private void verifyParam(BcmFullSyncCostReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCostList())) {
            throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4fe1\u606flist\u4e0d\u80fd\u4e3anull");
        }
        for (BcmCostInfoBO bo : reqBO.getCostList()) {
            if (StringUtils.isEmpty((Object)bo.getCostCenterCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getCostCenterName())) {
                throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4e2d\u5fc3\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgName())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getStatus() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2\u72b6\u6001\u4e0d\u80fd\u4e3anull");
        }
    }
}

