/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmIncrementSyncPaymentProjectService;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncPaymentProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncPaymentProjectRspBO;
import com.tydic.bcm.personal.common.bo.BcmPaymentProjectInfoBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPaymentProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmPaymentProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryPaymentProjectInfoPO;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmIncrementSyncPaymentProjectService"})
public class BcmIncrementSyncPaymentProjectServiceImpl
implements BcmIncrementSyncPaymentProjectService {
    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;

    @PostMapping(value={"incrementSyncPaymentProject"})
    public BcmIncrementSyncPaymentProjectRspBO incrementSyncPaymentProject(@RequestBody BcmIncrementSyncPaymentProjectReqBO reqBO) {
        this.verifyParam(reqBO);
        this.incSyncPaymentProject(reqBO);
        return PerSonalRuUtil.success(BcmIncrementSyncPaymentProjectRspBO.class);
    }

    private void incSyncPaymentProject(BcmIncrementSyncPaymentProjectReqBO reqBO) {
        ArrayList<BcmPaymentProjectInfoPO> addList = new ArrayList<BcmPaymentProjectInfoPO>(reqBO.getChangeList().size());
        ArrayList<BcmPaymentProjectInfoPO> updateList = new ArrayList<BcmPaymentProjectInfoPO>(reqBO.getChangeList().size());
        Date now = new Date();
        List<String> projectCodeList = this.getExistProjectCode(reqBO);
        for (BcmPaymentProjectInfoBO bo : reqBO.getChangeList()) {
            BcmPaymentProjectInfoPO po = new BcmPaymentProjectInfoPO();
            if (!projectCodeList.contains(bo.getProjectCode())) {
                po = (BcmPaymentProjectInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), BcmPaymentProjectInfoPO.class);
                po.setId(IdUtil.nextId());
                po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                if (po.getCreateTime() == null) {
                    po.setCreateTime(now);
                }
                if (po.getUpdateTime() == null) {
                    po.setUpdateTime(now);
                }
                addList.add(po);
                continue;
            }
            po = (BcmPaymentProjectInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), BcmPaymentProjectInfoPO.class);
            if (po.getUpdateTime() == null) {
                po.setUpdateTime(now);
            }
            updateList.add(po);
        }
        if (CollectionUtils.isEmpty(addList)) {
            this.bcmPaymentProjectInfoMapper.insertBatch(addList);
        }
        if (CollectionUtils.isEmpty(updateList)) {
            this.bcmPaymentProjectInfoMapper.updateBatch(updateList);
        }
    }

    private List<String> getExistProjectCode(BcmIncrementSyncPaymentProjectReqBO reqBO) {
        BcmQueryPaymentProjectInfoPO bcmQueryPaymentProjectInfoPO = new BcmQueryPaymentProjectInfoPO();
        bcmQueryPaymentProjectInfoPO.setProjectCodeList(reqBO.getChangeList().stream().map(BcmPaymentProjectInfoBO::getProjectCode).collect(Collectors.toList()));
        List<BcmPaymentProjectInfoPO> list = this.bcmPaymentProjectInfoMapper.getList(bcmQueryPaymentProjectInfoPO);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(BcmPaymentProjectInfoPO::getProjectCode).collect(Collectors.toList());
    }

    private void verifyParam(BcmIncrementSyncPaymentProjectReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getChangeList())) {
            throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4fe1\u606flist\u4e0d\u80fd\u4e3anull");
        }
        for (BcmPaymentProjectInfoBO bo : reqBO.getChangeList()) {
            if (StringUtils.isEmpty((Object)bo.getProjectCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProjectName())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgName())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getStatus() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2\u72b6\u6001\u4e0d\u80fd\u4e3anull");
        }
    }
}

