/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryPaymentProjectPageListService;
import com.tydic.bcm.personal.common.bo.BcmPaymentProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmQueryPaymentProjectPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryPaymentProjectPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPaymentProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmPaymentProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryPaymentProjectInfoPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmQueryPaymentProjectPageListService"})
public class BcmQueryPaymentProjectPageListServiceImpl
implements BcmQueryPaymentProjectPageListService {
    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;

    @PostMapping(value={"queryPaymentProjectPageList"})
    public BcmQueryPaymentProjectPageListRspBO queryPaymentProjectPageList(@RequestBody BcmQueryPaymentProjectPageListReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmQueryPaymentProjectInfoPO bcmQueryPaymentProjectInfoPO = this.getBcmQueryPaymentProjectInfoPO(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmPaymentProjectInfoPO> list = this.bcmPaymentProjectInfoMapper.getListPage(bcmQueryPaymentProjectInfoPO, (Page<BcmPaymentProjectInfoPO>)page);
        return this.setRspBO(list, (Page<BcmPaymentProjectInfoPO>)page);
    }

    private BcmQueryPaymentProjectPageListRspBO setRspBO(List<BcmPaymentProjectInfoPO> list, Page<BcmPaymentProjectInfoPO> page) {
        BcmQueryPaymentProjectPageListRspBO rspBO = PerSonalRuUtil.success(BcmQueryPaymentProjectPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(PerSonalRuUtil.jsl(list, BcmPaymentProjectInfoBO.class));
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (BcmPaymentProjectInfoBO bo : rspBO.getRows()) {
                if (BcmPersonalCommonConstant.Status.DISABLE.equals(bo.getStatus())) {
                    bo.setStatusStr("\u505c\u7528");
                    continue;
                }
                if (!BcmPersonalCommonConstant.Status.ENABLE.equals(bo.getStatus())) continue;
                bo.setStatusStr("\u542f\u7528");
            }
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private BcmQueryPaymentProjectInfoPO getBcmQueryPaymentProjectInfoPO(BcmQueryPaymentProjectPageListReqBO reqBO) {
        BcmQueryPaymentProjectInfoPO bcmQueryPaymentProjectInfoPO = (BcmQueryPaymentProjectInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), BcmQueryPaymentProjectInfoPO.class);
        bcmQueryPaymentProjectInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryPaymentProjectInfoPO.setOrderBy("UPDATE_TIME DESC");
        return bcmQueryPaymentProjectInfoPO;
    }

    private void verifyParam(BcmQueryPaymentProjectPageListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
    }
}

