/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmSubmitDealOpinionService;
import com.tydic.bcm.personal.common.bo.BcmSubmitDealOpinionReqBO;
import com.tydic.bcm.personal.common.bo.BcmSubmitDealOpinionRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmSuggestedManagementInfoMapper;
import com.tydic.bcm.personal.po.BcmSuggestedManagementInfoPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmSubmitDealOpinionService"})
public class BcmSubmitDealOpinionServiceImpl
implements BcmSubmitDealOpinionService {
    @Autowired
    private BcmSuggestedManagementInfoMapper bcmSuggestedManagementInfoMapper;

    @PostMapping(value={"submitDealOpinion"})
    public BcmSubmitDealOpinionRspBO submitDealOpinion(@RequestBody BcmSubmitDealOpinionReqBO reqBO) {
        this.verifyParam(reqBO);
        this.subDealOpinion(reqBO);
        return PerSonalRuUtil.success(BcmSubmitDealOpinionRspBO.class);
    }

    private void subDealOpinion(BcmSubmitDealOpinionReqBO reqBO) {
        BcmSuggestedManagementInfoPO set = (BcmSuggestedManagementInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), BcmSuggestedManagementInfoPO.class);
        set.setDealStatus(BcmPersonalCommonConstant.DealStatus.PROCESSED);
        BcmSuggestedManagementInfoPO where = new BcmSuggestedManagementInfoPO();
        where.setSuggestedId(reqBO.getSuggestedId());
        this.bcmSuggestedManagementInfoMapper.updateBy(set, where);
    }

    private void verifyParam(BcmSubmitDealOpinionReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getSuggestedId() == null) {
            throw new ZTBusinessException("\u5efa\u8bae\u5355id\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getDealUserId() == null) {
            throw new ZTBusinessException("\u5904\u7406\u4ebaid\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isEmpty((Object)reqBO.getDealUserName())) {
            throw new ZTBusinessException("\u5904\u7406\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getDealTime() == null) {
            throw new ZTBusinessException("\u5904\u7406\u65f6\u95f4\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isEmpty((Object)reqBO.getDealOpinion())) {
            throw new ZTBusinessException("\u5904\u7406\u610f\u89c1\u4e0d\u80fd\u4e3anull");
        }
    }
}

