/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.settle.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalSettleConstant;
import com.tydic.bcm.personal.dao.BcmBondDeductInfoMapper;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.settle.api.BcmAddBondDeductService;
import com.tydic.bcm.personal.settle.bo.BcmAddBondDeductReqBO;
import com.tydic.bcm.personal.settle.bo.BcmAddBondDeductRspBO;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.settle.api.BcmAddBondDeductService"})
public class BcmAddBondDeductServiceImpl
implements BcmAddBondDeductService {
    @Autowired
    private BcmBondDeductInfoMapper bcmBondDeductInfoMapper;

    @PostMapping(value={"addBondDeduct"})
    public BcmAddBondDeductRspBO addBondDeduct(@RequestBody BcmAddBondDeductReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmBondDeductInfoPO bcmBondDeductInfoPO = this.getBcmBondDeductInfoPO(reqBO);
        this.bcmBondDeductInfoMapper.insert(bcmBondDeductInfoPO);
        return PerSonalRuUtil.success(BcmAddBondDeductRspBO.class);
    }

    private BcmBondDeductInfoPO getBcmBondDeductInfoPO(BcmAddBondDeductReqBO reqBO) {
        BcmBondDeductInfoPO bcmBondDeductInfoPO = (BcmBondDeductInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), BcmBondDeductInfoPO.class);
        bcmBondDeductInfoPO.setDelFlag(BcmPersonalSettleConstant.DelFlag.NO);
        bcmBondDeductInfoPO.setCreateTime(new Date());
        bcmBondDeductInfoPO.setId(IdUtil.nextId());
        bcmBondDeductInfoPO.setDocId(IdUtil.nextId());
        bcmBondDeductInfoPO.setDocStatus(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMING);
        bcmBondDeductInfoPO.setDocCode("DZJ" + DateTimeFormatter.ofPattern("yyyyMMddHHmmssSS").format(LocalDateTime.now()) + String.format("%04d", new Random().nextInt(9999)));
        return bcmBondDeductInfoPO;
    }

    private void verifyParam(BcmAddBondDeductReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getSupplierId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isEmpty((Object)reqBO.getSupplierName())) {
            throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getDeductAmt() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u6263\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getCreateUserId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u521b\u5efa\u4ebaid\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCreateUserName())) {
            throw new ZTBusinessException("\u5165\u53c2\u521b\u5efa\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3anull");
        }
    }
}

