/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.settle.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalSettleConstant;
import com.tydic.bcm.personal.dao.BcmBondDeductInfoMapper;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.settle.api.BcmConfirmBondDeductService;
import com.tydic.bcm.personal.settle.bo.BcmConfirmBondDeductReqBO;
import com.tydic.bcm.personal.settle.bo.BcmConfirmBondDeductRspBO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.settle.api.BcmConfirmBondDeductService"})
public class BcmConfirmBondDeductServiceImpl
implements BcmConfirmBondDeductService {
    @Autowired
    private BcmBondDeductInfoMapper bcmBondDeductInfoMapper;

    @PostMapping(value={"confirmBondDeduct"})
    public BcmConfirmBondDeductRspBO confirmBondDeduct(@RequestBody BcmConfirmBondDeductReqBO reqBO) {
        this.verifyParam(reqBO);
        this.check(reqBO);
        BcmBondDeductInfoPO bcmBondDeductInfoPO = this.getBcmBondDeductInfoPO(reqBO);
        this.bcmBondDeductInfoMapper.updateById(bcmBondDeductInfoPO);
        return PerSonalRuUtil.success(BcmConfirmBondDeductRspBO.class);
    }

    private void check(BcmConfirmBondDeductReqBO reqBO) {
        BcmBondDeductInfoPO bcmBondDeductInfoPO = new BcmBondDeductInfoPO();
        bcmBondDeductInfoPO.setId(reqBO.getId());
        bcmBondDeductInfoPO = this.bcmBondDeductInfoMapper.getModelBy(bcmBondDeductInfoPO);
        if (!BcmPersonalSettleConstant.BondDeductStatus.CONFIRMING.equals(bcmBondDeductInfoPO.getDocStatus())) {
            throw new ZTBusinessException("\u8be5\u7533\u8bf7\u5355\u5df2\u7ecf\u64cd\u4f5c\u8fc7\u4e86");
        }
    }

    private BcmBondDeductInfoPO getBcmBondDeductInfoPO(BcmConfirmBondDeductReqBO reqBO) {
        BcmBondDeductInfoPO bcmBondDeductInfoPO = new BcmBondDeductInfoPO();
        bcmBondDeductInfoPO.setId(reqBO.getId());
        bcmBondDeductInfoPO.setUpdateUserName(reqBO.getUserName());
        bcmBondDeductInfoPO.setUpdateUserId(reqBO.getUserId());
        bcmBondDeductInfoPO.setUpdateTime(new Date());
        bcmBondDeductInfoPO.setConfirmUserId(reqBO.getUserId());
        bcmBondDeductInfoPO.setConfirmUserName(reqBO.getUserName());
        if (BcmPersonalSettleConstant.ConfirmBondDeductOperType.VERIFY.equals(reqBO.getOperType())) {
            bcmBondDeductInfoPO.setDocStatus(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMED);
        } else if (BcmPersonalSettleConstant.ConfirmBondDeductOperType.REJECT.equals(reqBO.getOperType())) {
            bcmBondDeductInfoPO.setDocStatus(BcmPersonalSettleConstant.BondDeductStatus.DECLINED);
        } else {
            throw new ZTBusinessException("\u9519\u8bef\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        return bcmBondDeductInfoPO;
    }

    private void verifyParam(BcmConfirmBondDeductReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getId() == null) {
            throw new ZTBusinessException("\u5165\u53c2id\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getOperType() == null) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3anull");
        }
    }
}

