package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.bo.*;
import com.tydic.bcm.personal.common.bo.BcmFileBO;
import com.tydic.bcm.personal.common.bo.BcmFlowTaskBO;
import com.tydic.bcm.personal.constants.*;
import com.tydic.bcm.personal.dao.*;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 上架申请单-查看详情
 * @author : civism
 * @version 1.0
 * @date 2023/7/28 14:55
 */
@HTServiceImpl
public class BcmQueryApplyOrderDetailServiceImpl implements BcmQueryApplyOrderDetailService {

    @Autowired
    private  BcmApplyCommodityOrderMapper applyCommodityOrderMapper;

    @Autowired
    private  BcmApplyCommodityOrderItemMapper applyCommodityOrderItemMapper;

    @Autowired
    private  BcmFileMapper fileMapper;

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @Autowired
    private BcmFlowTaskMapper bcmFlowTaskMapper;

    @Autowired
    private BcmFlowInstanceMapper bcmFlowInstanceMapper;

    /**
     * 查看详情
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryApplyOrderDetailRspBO queryApplyOrderDetail(BcmQueryApplyOrderDetailReqBO reqBO) {
        //参数验证
        verifyParam(reqBO);
        return setRspBO(reqBO);
    }

    /**
     * 出参组装
     *
     * @param reqBO
     * @return
     */
    private BcmQueryApplyOrderDetailRspBO setRspBO(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmFlowTaskBO taskBO = new BcmFlowTaskBO();
        //流程任务获取
        BcmQueryApplyOrderDetailRspBO rspBO = PerSonalRuUtil.success(BcmQueryApplyOrderDetailRspBO.class);
        if(!StringUtils.isEmpty(reqBO.getTaskId())){
           taskBO = getTask(reqBO);
        }
        //上架申请单获取
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = getBcmApplyCommodityOrder(reqBO);
        BcmApplyOrderBO bcmApplyOrder = PerSonalRuUtil.js(bcmApplyCommodityOrder, BcmApplyOrderBO.class);
        bcmApplyOrder.setTask(taskBO);
        bcmApplyOrder.setApplyOrderStatusStr(BcmPersonalApplyOrderStatusEnum.getStatusDesc(bcmApplyOrder.getApplyOrderStatus()));
        //上架申请单明细获取
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = getBcmApplyCommodityOrderItem(reqBO);
        if (bcmApplyCommodityOrderItem != null) {
            BcmApplyOrderItemBO bcmApplyOrderItemBO = PerSonalRuUtil.js(bcmApplyCommodityOrderItem, BcmApplyOrderItemBO.class);
            //上架申请单附件获取
            List<BcmFilePO> bcmFileList = getFileList(bcmApplyCommodityOrderItem);
            getFileList(bcmApplyCommodityOrderItem);
            if (CollectionUtils.isNotEmpty(bcmFileList)) {
                bcmApplyOrderItemBO.setFileList(BcmCommonBeanUtil.listCopyProperties(bcmFileList, BcmFileBO.class));
            }
            bcmApplyOrder.setApplyOrderItem(bcmApplyOrderItemBO);
        }
        if(BcmPersonalCommodityConstant.QueryReplyFlag.YES.equals(reqBO.getQueryReplyFlag())){
            //应答商品明细获取
            List<BcmApplyCommodityOrderSupplierReplyItemPO> bcmApplyCommodityOrderSupplierReplyItemPOS = getReplyCommodityList(reqBO);
            if(CollectionUtils.isNotEmpty(bcmApplyCommodityOrderSupplierReplyItemPOS)){
                List<BcmReplyApplyOrderItemBO> replyCommodityList = PerSonalRuUtil.jsl(bcmApplyCommodityOrderSupplierReplyItemPOS,BcmReplyApplyOrderItemBO.class);

                List<Long> replyItemIdList = bcmApplyCommodityOrderSupplierReplyItemPOS.stream().map(BcmApplyCommodityOrderSupplierReplyItemPO::getReplyItemId).collect(Collectors.toList());
                //应答商品明细附件获取
                List<BcmFilePO> filePOS = getFileList(replyItemIdList);

                //应答明细相关状态翻译
                for (BcmReplyApplyOrderItemBO itemBO:replyCommodityList){
                    itemBO.setSelectFlagStr(BcmPersonalCommonStatus.getStatusDesc(itemBO.getSelectFlag()));
                    itemBO.setPushFlagStr(BcmPersonalCommonStatus.getStatusDesc(itemBO.getPushFlag()));
                    itemBO.setCommodityReplyTypeStr(BcmPersonalCommodityReplyType.getStatusDesc(itemBO.getCommodityReplyType()));
                }

                //应答商品明细附件设置
                if(CollectionUtils.isNotEmpty(filePOS)){
                    Map<Long,List<BcmFilePO>> fileMap = filePOS.stream().collect(Collectors.groupingBy(BcmFilePO::getBusinessId));
                    for (BcmReplyApplyOrderItemBO itemBO:replyCommodityList){
                        itemBO.setFileInfo(PerSonalRuUtil.jsl(fileMap.get(itemBO.getReplyItemId()),BcmFileBO.class));
                    }
                }
                bcmApplyOrder.setReplyCommodityList(replyCommodityList);
            }
        }
        //是否为定制商品翻译
        bcmApplyOrder.setIsCustomizedFlagStr(BcmPersonalCommonStatus.getStatusDesc(bcmApplyOrder.getIsCustomizedFlag()));
        rspBO.setApplyOrder(bcmApplyOrder);
        return rspBO;
    }

    /**
     * 上架申请单获取
     * @param reqBO
     * @return
     */
    private BcmApplyCommodityOrderPO getBcmApplyCommodityOrder(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = applyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrder == null) {
            throw new ZTBusinessException("未查询到上架申请单");
        }
        return bcmApplyCommodityOrder;
    }

    /**
     * 上架申请单明细获取
     *
     * @param reqBO
     * @return
     */
    private BcmApplyCommodityOrderItemPO getBcmApplyCommodityOrderItem(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = applyCommodityOrderItemMapper.queryByApplyOrderId(reqBO.getApplyOrderId());
        return bcmApplyCommodityOrderItem;
    }

    /**
     * 上架申请明细单附件获取
     *
     * @param bcmApplyCommodityOrderItem
     * @return
     */
    private List<BcmFilePO> getFileList(BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem) {
        BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
        bcmQueryFilePO.setBusinessId(bcmApplyCommodityOrderItem.getApplyOrderItemId());
        bcmQueryFilePO.setBusinessId(BcmPersonalCommonConstant.BusinessType.APPLY_ORDER_ITEM.longValue());
        bcmQueryFilePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return fileMapper.getList(bcmQueryFilePO);
    }

    /**
     * 应答商品明细附件获取
     * @return
     */
    private List<BcmFilePO> getFileList(List<Long> businessIdList){
        BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
        bcmQueryFilePO.setBusinessIdList(businessIdList);
        bcmQueryFilePO.setBusinessId(BcmPersonalCommonConstant.BusinessType.REPLY_ORDER_ITEM.longValue());
        bcmQueryFilePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return fileMapper.getList(bcmQueryFilePO);
    }
    /**
     * 应答商品明细获取
     * @param reqBO
     * @return
     */
    private List<BcmApplyCommodityOrderSupplierReplyItemPO> getReplyCommodityList(BcmQueryApplyOrderDetailReqBO reqBO){
        BcmApplyCommodityOrderSupplierReplyItemPO bcmApplyCommodityOrderSupplierReplyItemPO = new BcmApplyCommodityOrderSupplierReplyItemPO();
        bcmApplyCommodityOrderSupplierReplyItemPO.setApplyOrderId(reqBO.getApplyOrderId());
         bcmApplyCommodityOrderSupplierReplyItemPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return bcmApplyCommodityOrderSupplierReplyItemMapper.getList(bcmApplyCommodityOrderSupplierReplyItemPO);
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQueryApplyOrderDetailReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getApplyOrderId() == null && StringUtils.isEmpty(reqBO.getTaskId())){
            throw new ZTBusinessException("申请单id和流程任务id不能同时为null");
        }
    }

    /**
     * 流程任务获取
     * @param reqBO
     *
     */
    private BcmFlowTaskBO getTask(BcmQueryApplyOrderDetailReqBO reqBO){
        BcmFlowTaskPO bcmFlowTaskPO = bcmFlowTaskMapper.queryByTaskId(reqBO.getTaskId());
        if(bcmFlowTaskPO == null){
            throw new ZTBusinessException("未查询到流程任务信息");
        }
        BcmFlowInstancePO bcmFlowInstancePO = new BcmFlowInstancePO();
        bcmFlowInstancePO.setFlowInstId(bcmFlowTaskPO.getFlowInstId());
        BcmFlowInstancePO model = bcmFlowInstanceMapper.getModel(bcmFlowInstancePO);
        if(model == null){
            throw new ZTBusinessException("未查询到任务实例信息");
        }
        reqBO.setApplyOrderId(model.getObjId());
        return PerSonalRuUtil.js(bcmFlowTaskPO,BcmFlowTaskBO.class);
    }

}
