package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmUpdateApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

import java.util.Date;
import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/7/28 17:23
 * 修改上架申请单实现类
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmUpdateApplyCommodityOrderServiceImpl implements BcmUpdateApplyCommodityOrderService {

    private final BcmApplyCommodityOrderMapper applyCommodityOrderMapper;

    private final BcmApplyCommodityOrderItemMapper applyCommodityOrderItemMapper;

    private final BcmFileMapper fileMapper;


    @Override
    public BcmUpdateApplyCommodityOrderRspBO updateApplyCommodityOrder(BcmUpdateApplyCommodityOrderReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = applyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (!BcmPersonalApplyOrderStatusEnum.DRAFT.getStatus().equals(bcmApplyCommodityOrder.getApplyOrderStatus())) {
            throw new ZTBusinessException("该申请单不处于草稿状态,不能修改");
        }
        //修改申请单
        BcmApplyCommodityOrderPO updateOrder = BeanUtil.copyProperties(reqBO, BcmApplyCommodityOrderPO.class);
        updateOrder.setId(bcmApplyCommodityOrder.getId());
        updateOrder.setUpdateUserId(reqBO.getUpdateUserId());
        updateOrder.setUpdateUserName(reqBO.getUpdateUserName());
        updateOrder.setUpdateTime(new Date());
        applyCommodityOrderMapper.update(updateOrder);
        //修改申请单明细
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = BeanUtil.copyProperties(reqBO.getApplyCommodityOrderItem(), BcmApplyCommodityOrderItemPO.class);
        bcmApplyCommodityOrderItem.setUpdateUserId(reqBO.getUpdateUserId());
        bcmApplyCommodityOrderItem.setUpdateUserName(reqBO.getUpdateUserName());
        bcmApplyCommodityOrderItem.setUpdateTime(new Date());
        applyCommodityOrderItemMapper.updateByOrderItemId(bcmApplyCommodityOrderItem);
        //删除文件然后在新增
        fileMapper.deleteByBusinessId(bcmApplyCommodityOrderItem.getApplyOrderItemId());
        if (CollectionUtil.isNotEmpty(reqBO.getApplyCommodityOrderItem().getFileList())) {
            List<BcmFilePO> bcmFileList = BcmCommonBeanUtil.listCopyProperties(reqBO.getApplyCommodityOrderItem().getFileList(), BcmFilePO.class);
            bcmFileList.forEach(bcmFile -> {
                bcmFile.setId(IdUtil.nextId());
                bcmFile.setFileId(IdUtil.nextId() + "");
                bcmFile.setBusinessId(bcmApplyCommodityOrderItem.getApplyOrderItemId());
                bcmFile.setBusinessType(BcmPersonalCommonConstant.BusinessType.APPLY_ORDER_ITEM);
                bcmFile.setCreateTime(new Date());
                bcmFile.setCreateUserId(reqBO.getUpdateUserId());
                bcmFile.setCreateUserName(reqBO.getUpdateUserName());
                bcmFile.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            });
            fileMapper.insertBatch(bcmFileList);
        }
        return PerSonalRuUtil.success(BcmUpdateApplyCommodityOrderRspBO.class);
    }
}
