package com.tydic.bcm.personal.commodity.impl;

import com.tydic.bcm.personal.commodity.api.BcmUpdateStatusApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/1 09:58
 */
@HTServiceImpl
@RequiredArgsConstructor
@Slf4j
public class BcmUpdateStatusApplyCommodityOrderServiceImpl implements BcmUpdateStatusApplyCommodityOrderService {

    private final BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @Override
    public BcmUpdateStatusApplyCommodityOrderRspBO updateStatusApplyCommodityOrder(BcmUpdateStatusApplyCommodityOrderReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = BcmCommonBeanUtil.copyProperties(reqBO, BcmApplyCommodityOrderPO.class);
        bcmApplyCommodityOrderMapper.update(bcmApplyCommodityOrder);
        return PerSonalRuUtil.success(BcmUpdateStatusApplyCommodityOrderRspBO.class);
    }
}
