package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryNotRelPurchasePurposeForPaymentProjectListService;
import com.tydic.bcm.personal.common.bo.BcmPaymentProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmPurchasePurposeConfigBO;
import com.tydic.bcm.personal.common.bo.BcmQueryNotRelPurchasePurposeForPaymentProjectListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryNotRelPurchasePurposeForPaymentProjectListRspBO;
import com.tydic.bcm.personal.dao.BcmPaymentProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmPaymentProjectInfoPO;
import com.tydic.bcm.personal.po.BcmPurchasePurposeConfigPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： BcmQueryNotRelPurchasePurposeForPaymentProjectListServiceImpl
 * 说明：采购用途配置-未关联采购用途的收支项目列表查询(分页)实现
 *
 * @author： lishiqing
 * 时间： 2023/7/25 14:54
 */
@HTServiceImpl
public class BcmQueryNotRelPurchasePurposeForPaymentProjectListServiceImpl implements BcmQueryNotRelPurchasePurposeForPaymentProjectListService {

    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;

    @Override
    public BcmQueryNotRelPurchasePurposeForPaymentProjectListRspBO queryNotRelPurchasePurposeForPaymentProjectList(BcmQueryNotRelPurchasePurposeForPaymentProjectListReqBO reqBO) {
        BcmQueryNotRelPurchasePurposeForPaymentProjectListRspBO rspBO = new BcmQueryNotRelPurchasePurposeForPaymentProjectListRspBO();

        // 入参组装
        Page<BcmPaymentProjectInfoPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        BcmPaymentProjectInfoPO qryPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmPaymentProjectInfoPO.class);
        if (ObjectUtil.isNotEmpty(reqBO.getPaymentProjectName())) {
            qryPO.setProjectName(reqBO.getPaymentProjectName());
        }

        // 根据条件分页查询列表数据
        List<BcmPaymentProjectInfoPO> bcmPaymentProjectInfoPOList =  bcmPaymentProjectInfoMapper.queryNotRelPurchasePurposeForPaymentProjectList(qryPO,page);

        // 出参组装
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(bcmPaymentProjectInfoPOList) ?
                JSONObject.parseArray(JSONObject.toJSONString(bcmPaymentProjectInfoPOList), BcmPaymentProjectInfoBO.class) : new ArrayList<>());

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQueryNotRelPurchasePurposeForPaymentProjectListReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("未关联采购用途的收支项目列表查询入参未空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCreateCompanyId())) {
            throw new ZTBusinessException("未关联采购用途的收支项目列表查询入参公司ID【createCompanyId】未空");
        }
    }
}
