package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmRelPaymentProjectService;
import com.tydic.bcm.personal.common.bo.BcmRelPaymentProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmRelPaymentProjectRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndPaymentProjectRelMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndPaymentProjectRelPO;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 类名： BcmRelPaymentProjectServiceImpl
 * 说明：采购用途设置-采购用途与收支项目关联实现
 *
 * @author： lishiqing
 * 时间： 2023/7/25 13:45
 */
@HTServiceImpl
public class BcmRelPaymentProjectServiceImpl implements BcmRelPaymentProjectService {

    @Autowired
    private BcmPurchasePurposeAndPaymentProjectRelMapper bcmPurchasePurposeAndPaymentProjectRelMapper;

    @Override
    public BcmRelPaymentProjectRspBO relPaymentProject(BcmRelPaymentProjectReqBO reqBO) {
        BcmRelPaymentProjectRspBO rspBO = new BcmRelPaymentProjectRspBO();

        // 参数校验
        verifyParam(reqBO);

        // 入参组装
        BcmPurchasePurposeAndPaymentProjectRelPO insertPO = setReqBO(reqBO);

        // 插入数据
        int i = bcmPurchasePurposeAndPaymentProjectRelMapper.insert(insertPO);
        if (i < 1) {
            throw new ZTBusinessException("采购用途与收支项目关联失败");
        }

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 入参组装
     * @param reqBO
     * @return
     */
    private BcmPurchasePurposeAndPaymentProjectRelPO setReqBO(BcmRelPaymentProjectReqBO reqBO) {
        BcmPurchasePurposeAndPaymentProjectRelPO insertPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmPurchasePurposeAndPaymentProjectRelPO.class);
        insertPO.setId(IdUtil.nextId());
        insertPO.setRelStatus(BcmPersonalCommonConstant.RelStatus.ASSOCIATED);
        insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        insertPO.setCreateTime(new DateTime());
        return insertPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmRelPaymentProjectReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("采购用途与收支项目关联实现入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeId())) {
            throw new ZTBusinessException("采购用途与收支项目关联实现入参采购用途ID【purchasePurposeId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeName())) {
            throw new ZTBusinessException("采购用途与收支项目关联实现入参采购用途名称【purchasePurposeName】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPaymentProjectId())) {
            throw new ZTBusinessException("采购用途与收支项目关联实现入参收支项目ID【paymentProjectId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPaymentProjectName())) {
            throw new ZTBusinessException("采购用途与收支项目关联实现入参收支项目名称【paymentProjectName】为空");
        }
    }
}
