package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * 标题 BcmPersonalCommodityReplyType
 * 说明 商品应答类型
 * 时间 2023/7/31 11:58
 *
 * @author 唐富强
 */
public enum BcmPersonalCommodityReplyType {


    /**
     * 商品应答类型
     */
    HITCH(1, "挂接商品"),
    GOODS(2, "商品信息"),
    ;

    @Getter
    private final Integer status;

    @Getter
    private final String desc;

    BcmPersonalCommodityReplyType(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }


    /**
     * 翻译获取
     *
     * @param status
     * @return
     */
    public static String getStatusDesc(Integer status) {
        BcmPersonalCommodityReplyType[] values = BcmPersonalCommodityReplyType.values();
        for (BcmPersonalCommodityReplyType applyOrderStatus : values) {
            if (applyOrderStatus.getStatus().equals(status)) {
                return applyOrderStatus.getDesc();
            }
        }
        return null;
    }
}
