package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * 标题 BcmPerSonalCommonStatus
 * 说明 通用状态
 * 时间 2023/7/31 11:50
 *
 * @author 唐富强
 */
public enum BcmPersonalCommonStatus {


    /**
     * 通用状态
     */
    YES(0, "是"),
    IN_APPROVAL(0, "否"),
    ;

    @Getter
    private final Integer status;

    @Getter
    private final String desc;

    BcmPersonalCommonStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }


    /**
     * 状态翻译获取
     * @param status
     * @return
     */
    public static String getStatusDesc(Integer status) {
        BcmPersonalApplyOrderStatusEnum[] values = BcmPersonalApplyOrderStatusEnum.values();
        for (BcmPersonalApplyOrderStatusEnum applyOrderStatus : values) {
            if (applyOrderStatus.getStatus().equals(status)) {
                return applyOrderStatus.getDesc();
            }
        }
        return null;
    }
}
