package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题 BcmBondDeductInfoPO
 * 说明 保证金扣除申请信息PO
 * 时间 2023/7/25 10:07
 *
 * @author 唐富强
 */
@Data
public class BcmBondDeductInfoPO implements Serializable {


    private static final long serialVersionUID = -4887625590704720411L;
    private Long id;

    /**
     * 单据id
     */
    private Long docId;

    /**
     * 单据号
     */
    private String docCode;


    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 供应商code
     */
    private String supplierCode;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 扣款金额
     */
    private BigDecimal deductAmt;

    /**
     * 扣款事项
     */
    private String deductReason;


    /**
     * 单据状态 1确认中2已拒绝3已确认
     */
    private Integer docStatus;

    /**
     * 确认人id
     */
    private Long confirmUserId;

    /**
     * 确认人姓名
     */
    private String confirmUserName;

    /**
     * 确认时间
     */
    private Date confirmTime;

    /**
     * 删除标识 0-未删除 1-删除
     */
    private Integer delFlag;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新人id
     */
    private Long updateUserId;

    /**
     * 更新时间
     */
    private Date updateTime;


    /**
     * 发起开始时间
     */
    private Date createStartTime;

    /**
     * 发起结束时间
     */
    private Date createEndTime;

    /**
     * 排序
     */
    private String orderBy;

    /**
     * 数据id集合
     */
    private List<Long> ids;

}
