package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题 BcmQueryBasicProjectInfoPO
 * 说明 项目基本信息查询PO
 * 时间 2023/8/1 17:17
 *
 * @author 唐富强
 */
@Data
public class BcmQueryBasicProjectInfoPO implements Serializable {

    private static final long serialVersionUID = -4421840662382042652L;
    private Long id;

    /**
     * 项目名称
     */
    private String projectName;


    /**
     * 项目编号
     */
    private String projectCode;

    /**
     * 项目Id
     */
    private String projectId;

    /**
     * 预算金额
     */
    private BigDecimal budgetMoney;

    /**
     * 采购组织编码
     */
    private String proOrgCode;

    /**
     * 采购组织名称
     */
    private String proOrgName;

    /**
     * 采购组织id
     */
    private String proOrgId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新人id
     */
    private Long updateUserId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 状态 0-停用 1-启用
     */
    private Integer status;

    /**
     * 更新开始时间
     */
    private Date updateStartTime;

    /**
     * 更新结束时间
     */
    private Date updateEndTime;

    /**
     * 删除标识 0-未删除 1-删除
     */
    private Integer delFlag;

    /**
     * 排序
     */
    private String orderBy;

    /**
     * 项目编号集合
     */
    private List<String> projectCodeList;
}
