package com.tydic.bcm.personal.settle.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalSettleConstant;
import com.tydic.bcm.personal.dao.BcmBondDeductInfoMapper;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.settle.api.BcmAddBondDeductService;
import com.tydic.bcm.personal.settle.bo.BcmAddBondDeductReqBO;
import com.tydic.bcm.personal.settle.bo.BcmAddBondDeductRspBO;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.poi.ss.usermodel.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Random;

/**
 * 标题 BcmAddBondDeductServiceImpl
 * 说明 保证金管理-保证金扣除申请单新增
 * 时间 2023/7/25 11:10
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmAddBondDeductServiceImpl implements BcmAddBondDeductService {

    @Autowired
    private BcmBondDeductInfoMapper bcmBondDeductInfoMapper;


    /**
     * 保证金扣除申请单新增
     * @param reqBO
     * @return
     */
    @Override
    public BcmAddBondDeductRspBO addBondDeduct(BcmAddBondDeductReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmBondDeductInfoPO bcmBondDeductInfoPO = getBcmBondDeductInfoPO(reqBO);
        bcmBondDeductInfoMapper.insert(bcmBondDeductInfoPO);
        return PerSonalRuUtil.success(BcmAddBondDeductRspBO.class);
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmBondDeductInfoPO getBcmBondDeductInfoPO(BcmAddBondDeductReqBO reqBO){
        BcmBondDeductInfoPO bcmBondDeductInfoPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO),BcmBondDeductInfoPO.class);
        bcmBondDeductInfoPO.setDelFlag(BcmPersonalSettleConstant.DelFlag.NO);
        bcmBondDeductInfoPO.setCreateTime(new Date());
        bcmBondDeductInfoPO.setId(IdUtil.nextId());
        bcmBondDeductInfoPO.setDocId(IdUtil.nextId());
        bcmBondDeductInfoPO.setDocStatus(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMING);
        bcmBondDeductInfoPO.setDocCode("DZJ"+ DateTimeFormatter.ofPattern("yyyyMMddHHmmssSS").format(LocalDateTime.now())+String.format("%04d",new Random().nextInt(9999)));
        return bcmBondDeductInfoPO;
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmAddBondDeductReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getSupplierId() == null){
            throw new ZTBusinessException("入参供应商id不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getSupplierName())){
            throw new ZTBusinessException("入参供应商名称不能为null");
        }
        if(reqBO.getDeductAmt() == null){
            throw new ZTBusinessException("入参扣款金额不能为null");
        }
        if(reqBO.getCreateUserId() == null){
            throw new ZTBusinessException("入参创建人id不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getCreateUserName())){
            throw new ZTBusinessException("入参创建人名称不能为null");
        }
    }
}
