package com.tydic.bcm.personal.settle.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalSettleConstant;
import com.tydic.bcm.personal.dao.BcmBondDeductInfoMapper;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.settle.api.BcmConfirmBondDeductService;
import com.tydic.bcm.personal.settle.bo.BcmConfirmBondDeductReqBO;
import com.tydic.bcm.personal.settle.bo.BcmConfirmBondDeductRspBO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 标题 BcmConfirmBondDeductServiceImpl
 * 说明 保证金管理-保证金扣除申请单确认/拒绝实现
 * 时间 2023/7/25 14:58
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmConfirmBondDeductServiceImpl implements BcmConfirmBondDeductService {

    @Autowired
    private BcmBondDeductInfoMapper bcmBondDeductInfoMapper;

    /**
     * 保证金扣除申请单确认/拒绝
     * @param reqBO
     * @return
     */
    @Override
    public BcmConfirmBondDeductRspBO confirmBondDeduct(BcmConfirmBondDeductReqBO reqBO) {
        //参数验证
        verifyParam(reqBO);
        //是否可进行确认/拒绝操作校验
        check(reqBO);
        //参数组装
        BcmBondDeductInfoPO bcmBondDeductInfoPO = getBcmBondDeductInfoPO(reqBO);
        bcmBondDeductInfoMapper.updateById(bcmBondDeductInfoPO);
        return PerSonalRuUtil.success(BcmConfirmBondDeductRspBO.class);
    }

    /**
     * 是否可进行确认/拒绝操作校验
     * @param reqBO
     */
    private void check(BcmConfirmBondDeductReqBO reqBO){
        BcmBondDeductInfoPO bcmBondDeductInfoPO = new BcmBondDeductInfoPO();
        bcmBondDeductInfoPO.setId(reqBO.getId());
        bcmBondDeductInfoPO = bcmBondDeductInfoMapper.getModelBy(bcmBondDeductInfoPO);
        if(!BcmPersonalSettleConstant.BondDeductStatus.CONFIRMING.equals(bcmBondDeductInfoPO.getDocStatus())){
            throw new ZTBusinessException("该申请单已经操作过了");
        }
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmBondDeductInfoPO getBcmBondDeductInfoPO(BcmConfirmBondDeductReqBO reqBO){
        BcmBondDeductInfoPO bcmBondDeductInfoPO = new BcmBondDeductInfoPO();
        bcmBondDeductInfoPO.setId(reqBO.getId());
        bcmBondDeductInfoPO.setUpdateUserName(reqBO.getUserName());
        bcmBondDeductInfoPO.setUpdateUserId(reqBO.getUserId());
        bcmBondDeductInfoPO.setUpdateTime(new Date());
        bcmBondDeductInfoPO.setConfirmUserId(reqBO.getUserId());
        bcmBondDeductInfoPO.setConfirmUserName(reqBO.getUserName());
        if(BcmPersonalSettleConstant.ConfirmBondDeductOperType.VERIFY.equals(reqBO.getOperType())){
            bcmBondDeductInfoPO.setDocStatus(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMED);
        } else if (BcmPersonalSettleConstant.ConfirmBondDeductOperType.REJECT.equals(reqBO.getOperType())) {
            bcmBondDeductInfoPO.setDocStatus(BcmPersonalSettleConstant.BondDeductStatus.DECLINED);
        }else {
            throw new ZTBusinessException("错误的操作类型");
        }
        return bcmBondDeductInfoPO;
    }


    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmConfirmBondDeductReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getId() == null){
            throw new ZTBusinessException("入参id不能为null");
        }
        if(reqBO.getOperType() == null){
            throw new ZTBusinessException("操作类型不能为null");
        }
    }
}
