/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmIncrementSyncBudgetProjectService;
import com.tydic.bcm.personal.common.bo.BcmBudgetProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncBudgetProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncBudgetProjectRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBudgetProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBudgetProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmIncrementSyncBudgetProjectService"})
public class BcmIncrementSyncBudgetProjectServiceImpl
implements BcmIncrementSyncBudgetProjectService {
    @Autowired
    private BcmBudgetProjectInfoMapper bcmBudgetProjectInfoMapper;

    @PostMapping(value={"incrementSyncBudgetProject"})
    public BcmIncrementSyncBudgetProjectRspBO incrementSyncBudgetProject(@RequestBody BcmIncrementSyncBudgetProjectReqBO reqBO) {
        this.verifyParam(reqBO);
        this.incSyncBudgetProjectR(reqBO);
        return BcmRuUtil.success(BcmIncrementSyncBudgetProjectRspBO.class);
    }

    private void incSyncBudgetProjectR(BcmIncrementSyncBudgetProjectReqBO reqBO) {
        ArrayList<BcmBudgetProjectInfoPO> addList = new ArrayList<BcmBudgetProjectInfoPO>(reqBO.getChangeList().size());
        ArrayList<BcmBudgetProjectInfoPO> updateList = new ArrayList<BcmBudgetProjectInfoPO>(reqBO.getChangeList().size());
        List<String> projectCodeList = this.getExistProjectCode(reqBO);
        Date now = new Date();
        for (BcmBudgetProjectInfoBO bo : reqBO.getChangeList()) {
            BcmBudgetProjectInfoPO po;
            if (!projectCodeList.contains(bo.getProjectCode())) {
                po = (BcmBudgetProjectInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), BcmBudgetProjectInfoPO.class);
                po.setId(BcmIdUtil.nextId());
                po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                if (po.getCreateTime() == null) {
                    po.setCreateTime(now);
                }
                if (po.getUpdateTime() == null) {
                    po.setUpdateTime(now);
                }
                addList.add(po);
                continue;
            }
            po = (BcmBudgetProjectInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), BcmBudgetProjectInfoPO.class);
            if (po.getUpdateTime() == null) {
                po.setUpdateTime(now);
            }
            updateList.add(po);
        }
        if (!CollectionUtils.isEmpty(addList)) {
            this.bcmBudgetProjectInfoMapper.insertBatch(addList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.bcmBudgetProjectInfoMapper.updateBatch(updateList);
        }
    }

    private List<String> getExistProjectCode(BcmIncrementSyncBudgetProjectReqBO reqBO) {
        BcmQueryBudgetProjectInfoPO bcmQueryBudgetProjectInfoPO = new BcmQueryBudgetProjectInfoPO();
        bcmQueryBudgetProjectInfoPO.setProjectCodeList(reqBO.getChangeList().stream().map(BcmBudgetProjectInfoBO::getProjectCode).collect(Collectors.toList()));
        List<BcmBudgetProjectInfoPO> list = this.bcmBudgetProjectInfoMapper.getList(bcmQueryBudgetProjectInfoPO);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(BcmBudgetProjectInfoPO::getProjectCode).collect(Collectors.toList());
    }

    private void verifyParam(BcmIncrementSyncBudgetProjectReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getChangeList())) {
            throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4fe1\u606flist\u4e0d\u80fd\u4e3anull");
        }
        for (BcmBudgetProjectInfoBO bo : reqBO.getChangeList()) {
            if (StringUtils.isEmpty((Object)bo.getProjectCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProjectName())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgName())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getStatus() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2\u72b6\u6001\u4e0d\u80fd\u4e3anull");
        }
    }
}

