/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmIncrementSyncBasicProjectService;
import com.tydic.bcm.personal.common.bo.BcmBasicProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncBasicProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncBasicProjectRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBasicProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBasicProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBasicProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmIncrementSyncBasicProjectService"})
public class BcmIncrementSyncBasicProjectServiceImpl
implements BcmIncrementSyncBasicProjectService {
    @Autowired
    private BcmBasicProjectInfoMapper bcmBasicProjectInfoMapper;

    @PostMapping(value={"incrementSyncBasicProject"})
    public BcmIncrementSyncBasicProjectRspBO incrementSyncBasicProject(@RequestBody BcmIncrementSyncBasicProjectReqBO reqBO) {
        this.verifyParam(reqBO);
        this.incSyncBasicProject(reqBO);
        return BcmRuUtil.success(BcmIncrementSyncBasicProjectRspBO.class);
    }

    private void incSyncBasicProject(BcmIncrementSyncBasicProjectReqBO reqBO) {
        ArrayList<BcmBasicProjectInfoPO> addList = new ArrayList<BcmBasicProjectInfoPO>(reqBO.getChangeList().size());
        ArrayList<BcmBasicProjectInfoPO> updateList = new ArrayList<BcmBasicProjectInfoPO>(reqBO.getChangeList().size());
        List<String> projectList = this.getExistProjectCode(reqBO);
        Date now = new Date();
        for (BcmBasicProjectInfoBO bo : reqBO.getChangeList()) {
            BcmBasicProjectInfoPO po;
            if (!projectList.contains(bo.getProjectCode())) {
                po = (BcmBasicProjectInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), BcmBasicProjectInfoPO.class);
                po.setId(BcmIdUtil.nextId());
                po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                if (po.getCreateTime() == null) {
                    po.setCreateTime(now);
                }
                if (po.getUpdateTime() == null) {
                    po.setUpdateTime(now);
                }
                addList.add(po);
                continue;
            }
            po = (BcmBasicProjectInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), BcmBasicProjectInfoPO.class);
            if (po.getUpdateTime() == null) {
                po.setUpdateTime(now);
            }
            updateList.add(po);
        }
        if (!CollectionUtils.isEmpty(addList)) {
            this.bcmBasicProjectInfoMapper.insertBatch(addList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.bcmBasicProjectInfoMapper.updateBatch(updateList);
        }
    }

    private List<String> getExistProjectCode(BcmIncrementSyncBasicProjectReqBO reqBO) {
        BcmQueryBasicProjectInfoPO bcmQueryBasicProjectInfoPO = new BcmQueryBasicProjectInfoPO();
        bcmQueryBasicProjectInfoPO.setProjectCodeList(reqBO.getChangeList().stream().map(BcmBasicProjectInfoBO::getProjectCode).collect(Collectors.toList()));
        List<BcmBasicProjectInfoPO> list = this.bcmBasicProjectInfoMapper.getList(bcmQueryBasicProjectInfoPO);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(BcmBasicProjectInfoPO::getProjectCode).collect(Collectors.toList());
    }

    private void verifyParam(BcmIncrementSyncBasicProjectReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getChangeList())) {
            throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4fe1\u606flist\u4e0d\u80fd\u4e3anull");
        }
        for (BcmBasicProjectInfoBO bo : reqBO.getChangeList()) {
            if (StringUtils.isEmpty((Object)bo.getProjectCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProjectName())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProOrgCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u91c7\u8d2d\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProOrgName())) {
                throw new ZTBusinessException("\u5165\u53c2\u91c7\u8d2d\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getBudgetMoney() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u9884\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getStatus() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2\u72b6\u6001\u4e0d\u80fd\u4e3anull");
        }
    }
}

