/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQueryFlowInstanceDetailService;
import com.tydic.bcm.personal.common.bo.BcmFlowInstanceBO;
import com.tydic.bcm.personal.common.bo.BcmFlowTaskBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFlowInstanceDetailReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFlowInstanceDetailRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmQueryFlowInstanceDetailService"})
public class BcmQueryFlowInstanceDetailServiceImpl
implements BcmQueryFlowInstanceDetailService {
    private final BcmFlowInstanceMapper flowInstanceMapper;
    private final BcmFlowTaskMapper flowTaskMapper;

    @PostMapping(value={"queryFlowInstanceDetail"})
    public BcmQueryFlowInstanceDetailRspBO queryFlowInstanceDetail(@RequestBody BcmQueryFlowInstanceDetailReqBO bcmQueryFlowInstanceDetailReqBO) {
        if (StrUtil.isEmpty((CharSequence)bcmQueryFlowInstanceDetailReqBO.getFlowInstId()) && bcmQueryFlowInstanceDetailReqBO.getObjId() == null) {
            throw new ZTBusinessException("objId\u6216flowInstId\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        BcmFlowInstancePO flowInstance = this.flowInstanceMapper.queryByObjIdOrFlowInstanceId(bcmQueryFlowInstanceDetailReqBO.getObjId(), bcmQueryFlowInstanceDetailReqBO.getFlowInstId());
        if (flowInstance == null) {
            throw new ZTBusinessException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        BcmFlowInstanceBO bcmFlowInstanceBO = BcmCommonBeanUtil.copyProperties(flowInstance, BcmFlowInstanceBO.class);
        if (BcmPersonalCommodityConstant.QueryTaskFlag.YES.equals(bcmQueryFlowInstanceDetailReqBO.getQueryTaskFlag())) {
            List<BcmFlowTaskPO> bcmFlowTaskPOS = this.flowTaskMapper.queryByFlowInstanceId(flowInstance.getFlowInstId());
            List<BcmFlowTaskBO> bcmFlowTaskList = BcmCommonBeanUtil.listCopyProperties(bcmFlowTaskPOS, BcmFlowTaskBO.class);
            bcmFlowInstanceBO.setBcmFlowTaskList(bcmFlowTaskList);
        }
        BcmQueryFlowInstanceDetailRspBO resp = new BcmQueryFlowInstanceDetailRspBO();
        resp.setFlowInstance(bcmFlowInstanceBO);
        return resp;
    }

    public BcmQueryFlowInstanceDetailServiceImpl(BcmFlowInstanceMapper flowInstanceMapper, BcmFlowTaskMapper flowTaskMapper) {
        this.flowInstanceMapper = flowInstanceMapper;
        this.flowTaskMapper = flowTaskMapper;
    }
}

