/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQuerySuggestedDetailService;
import com.tydic.bcm.personal.common.bo.BcmFileBO;
import com.tydic.bcm.personal.common.bo.BcmQuerySuggestedDetailReqBO;
import com.tydic.bcm.personal.common.bo.BcmQuerySuggestedDetailRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.dao.BcmSuggestedManagementInfoMapper;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.po.BcmQueryFilePO;
import com.tydic.bcm.personal.po.BcmSuggestedManagementInfoPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmQuerySuggestedDetailService"})
public class BcmQuerySuggestedDetailServiceImpl
implements BcmQuerySuggestedDetailService {
    @Autowired
    private BcmSuggestedManagementInfoMapper bcmSuggestedManagementInfoMapper;
    @Autowired
    private BcmFileMapper bcmFileMapper;

    @PostMapping(value={"querySuggestedDetail"})
    public BcmQuerySuggestedDetailRspBO querySuggestedDetail(@RequestBody BcmQuerySuggestedDetailReqBO reqBO) {
        this.verifyParam(reqBO);
        return this.setRspBO(reqBO);
    }

    private BcmSuggestedManagementInfoPO getSuggestedDetail(BcmQuerySuggestedDetailReqBO reqBO) {
        BcmSuggestedManagementInfoPO bcmSuggestedManagementInfoPO = new BcmSuggestedManagementInfoPO();
        bcmSuggestedManagementInfoPO.setSuggestedId(reqBO.getSuggestedId());
        BcmSuggestedManagementInfoPO modelBy = this.bcmSuggestedManagementInfoMapper.getModelBy(bcmSuggestedManagementInfoPO);
        return modelBy;
    }

    private List<BcmFilePO> getFileList(BcmQuerySuggestedDetailReqBO reqBO) {
        BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
        bcmQueryFilePO.setBusinessId(reqBO.getSuggestedId());
        bcmQueryFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.SUGGESTION);
        bcmQueryFilePO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        return this.bcmFileMapper.getList(bcmQueryFilePO);
    }

    private BcmQuerySuggestedDetailRspBO setRspBO(BcmQuerySuggestedDetailReqBO reqBO) {
        BcmQuerySuggestedDetailRspBO rspBO = BcmRuUtil.js(this.getSuggestedDetail(reqBO), BcmQuerySuggestedDetailRspBO.class);
        if (BcmPersonalCommonConstant.IsAnonymous.YES.equals(rspBO.getIsAnonymous())) {
            rspBO.setSuggestedUserId(null);
            rspBO.setSuggestedUserName("***");
            rspBO.setSuggestedOrgId(null);
            rspBO.setSuggestedOrgName("***");
            rspBO.setSuggestedCompanyId(null);
            rspBO.setSuggestedCompanyName("***");
        }
        if (BcmPersonalCommonConstant.SuggestedColumn.BUSINESS_EXCHANGE.toString().equals(rspBO.getSuggestedColumn())) {
            rspBO.setSuggestedColumnStr("\u4e1a\u52a1\u4ea4\u6d41");
        } else if (BcmPersonalCommonConstant.SuggestedColumn.PROBLEM_FEEDBACK.toString().equals(rspBO.getSuggestedColumn())) {
            rspBO.setSuggestedColumnStr("\u95ee\u9898\u53cd\u9988");
        } else if (BcmPersonalCommonConstant.SuggestedColumn.SYSTEM_SUGGESTION.toString().equals(rspBO.getSuggestedColumn())) {
            rspBO.setSuggestedColumnStr("\u7cfb\u7edf\u4f18\u5316\u5efa\u8bae");
        } else if (BcmPersonalCommonConstant.SuggestedColumn.VIOLATION_FEEDBACK.toString().equals(rspBO.getSuggestedColumn())) {
            rspBO.setSuggestedColumnStr("\u96c6\u4e2d\u91c7\u8d2d\u8fdd\u89c4\u95ee\u9898\u53cd\u9988");
        }
        rspBO.setFileBoList(BcmRuUtil.jsl(this.getFileList(reqBO), BcmFileBO.class));
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void verifyParam(BcmQuerySuggestedDetailReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u67e5\u8be2\u5efa\u8bae\u8be6\u60c5\u5165\u53c2\u4e3anull");
        }
        if (reqBO.getSuggestedId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5efa\u8bae\u5355id\u4e0d\u80fd\u4e3anull");
        }
    }
}

