/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.date.DateUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmUpdateStatusApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BooleanFlagEnum;
import com.tydic.bcm.personal.dao.BcmApplyCommodityConfMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityConfPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmUpdateStatusApplyCommodityOrderService"})
public class BcmUpdateStatusApplyCommodityOrderServiceImpl
implements BcmUpdateStatusApplyCommodityOrderService {
    private static final Logger log = LoggerFactory.getLogger(BcmUpdateStatusApplyCommodityOrderServiceImpl.class);
    private final BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;
    private final BcmApplyCommodityConfMapper bcmApplyCommodityConfMapper;

    @PostMapping(value={"updateStatusApplyCommodityOrder"})
    public BcmUpdateStatusApplyCommodityOrderRspBO updateStatusApplyCommodityOrder(@RequestBody BcmUpdateStatusApplyCommodityOrderReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        BcmApplyCommodityOrderPO existCommodityOrder = this.bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (existCommodityOrder == null) {
            throw new ZTBusinessException("\u4e0a\u67b6\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
        }
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = BcmCommonBeanUtil.copyProperties(reqBO, BcmApplyCommodityOrderPO.class);
        if (BooleanFlagEnum.YES.getFlag().equals(reqBO.getSelectDeadFlag()) && existCommodityOrder.getSelectDeadlineDate() == null) {
            BcmApplyCommodityConfPO bcmApplyCommodityConf = this.getBcmApplyCommodityConf(existCommodityOrder.getPurCompanyId());
            bcmApplyCommodityOrder.setSelectDeadlineDate((Date)DateUtil.offsetDay((Date)new Date(), (int)bcmApplyCommodityConf.getSelectDayLimit()));
        }
        this.bcmApplyCommodityOrderMapper.update(bcmApplyCommodityOrder);
        return BcmRuUtil.success(BcmUpdateStatusApplyCommodityOrderRspBO.class);
    }

    private BcmApplyCommodityConfPO getBcmApplyCommodityConf(Long companyId) {
        BcmApplyCommodityConfPO bcmApplyCommodityConfPO = new BcmApplyCommodityConfPO();
        bcmApplyCommodityConfPO.setCompanyId(companyId);
        BcmApplyCommodityConfPO model = this.bcmApplyCommodityConfMapper.getModel(bcmApplyCommodityConfPO);
        if (model == null) {
            BcmApplyCommodityConfPO defaultConf = new BcmApplyCommodityConfPO();
            defaultConf.setGlobalFlag(BcmPersonalCommodityConstant.GlobalFlag.YES);
            model = this.bcmApplyCommodityConfMapper.getModel(defaultConf);
        }
        if (model == null) {
            throw new ZTBusinessException("\u672a\u8bbe\u7f6e\u9009\u5b9a\u9ed8\u8ba4\u914d\u7f6e");
        }
        return model;
    }

    public BcmUpdateStatusApplyCommodityOrderServiceImpl(BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper, BcmApplyCommodityConfMapper bcmApplyCommodityConfMapper) {
        this.bcmApplyCommodityOrderMapper = bcmApplyCommodityOrderMapper;
        this.bcmApplyCommodityConfMapper = bcmApplyCommodityConfMapper;
    }
}

