package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmAddBatchApplyCommodityOrderSupplierReplyService;
import com.tydic.bcm.personal.commodity.bo.BcmAddBatchReplyCommodityReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmAddReplyCommodityBO;
import com.tydic.bcm.personal.commodity.bo.BcmaddBatchReplyCommodityRspBO;
import com.tydic.bcm.personal.common.bo.BcmFileBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题 BcmAddBatchApplyCommodityOrderSupplierReplyServiceImpl
 * 说明 上架申请单应答-挂接/新增/商品（批量）实现
 * 时间 2023/8/1 18:12
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmAddBatchApplyCommodityOrderSupplierReplyServiceImpl implements BcmAddBatchApplyCommodityOrderSupplierReplyService {

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyMapper bcmApplyCommodityOrderSupplierReplyMapper;

    @Autowired
    private BcmFileMapper bcmFileMapper;

    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    /**
     * 挂接/新增/商品（批量）实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmaddBatchReplyCommodityRspBO addBatchReplyCommodity(BcmAddBatchReplyCommodityReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //判断上架申请单能否进行应答
        check(reqBO);
        //应答单获取
        BcmApplyCommodityOrderSupplierReplyPO bcmApplyCommodityOrderSupplierReplyPO = getApplyCommodityOrderSupplierReply(reqBO);
        long replyId;
        //不存在应答明细单需要有应答明细才新增
        if (bcmApplyCommodityOrderSupplierReplyPO == null) {
            if (!CollectionUtils.isEmpty(reqBO.getReplyCommodityOrderItemList())) {
                //新增应答单
                replyId = addApplyCommodityOrderSupplierReply(reqBO);
                //新增应答明细
                addApplyCommodityOrderSupplierReplyItem(reqBO, replyId);
            }
        } else {
            replyId = bcmApplyCommodityOrderSupplierReplyPO.getReplyId();
            //逻辑删除应答明细附件
            updateFile(replyId);
            //逻辑删除应答明细
            updateApplyCommodityOrderSupplierReplyItem(reqBO, replyId);
            //新增应答明细
            if (!CollectionUtils.isEmpty(reqBO.getReplyCommodityOrderItemList())) {
                addApplyCommodityOrderSupplierReplyItem(reqBO, replyId);
            } else {
                //应答单没有应答明细删除应答单
                updateApplyCommodityOrderSupplierReply(reqBO, replyId);
            }

        }
        return BcmRuUtil.success(BcmaddBatchReplyCommodityRspBO.class);
    }

    /**
     * 判断上架申请单能否进行应答
     *
     * @param reqBO
     */
    private void check(BcmAddBatchReplyCommodityReqBO reqBO) {
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrderPO == null) {
            throw new ZTBusinessException("未找到上架申请单");
        }
        if (!BcmPersonalApplyOrderStatusEnum.IN_REPLY.getStatus().equals(bcmApplyCommodityOrderPO.getApplyOrderStatus())) {
            throw new ZTBusinessException("上架申请单状态不是应答中不能进行应答");
        }
    }
    /**
     * 新增应答单
     */
    private Long addApplyCommodityOrderSupplierReply(BcmAddBatchReplyCommodityReqBO reqBO) {
        long replyId = BcmIdUtil.nextId();
        BcmApplyCommodityOrderSupplierReplyPO bcmApplyCommodityOrderSupplierReplyPO = BcmRuUtil.js(reqBO, BcmQueryApplyCommodityOrderSupplierReplyPO.class);
        bcmApplyCommodityOrderSupplierReplyPO.setId(BcmIdUtil.nextId());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyId(replyId);
        bcmApplyCommodityOrderSupplierReplyPO.setReplyUserId(reqBO.getUserId());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyUserName(reqBO.getUserName());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyOrgId(reqBO.getOrgId());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyOrgName(reqBO.getOrgName());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyCompanyId(reqBO.getCompanyId());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyCompanyName(reqBO.getCompanyName());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyTime(new Date());
        bcmApplyCommodityOrderSupplierReplyPO.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
        bcmApplyCommodityOrderSupplierReplyPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        bcmApplyCommodityOrderSupplierReplyMapper.insert(bcmApplyCommodityOrderSupplierReplyPO);
        return replyId;
    }

    /**
     * 应答单明细获取
     * @param replyId
     * @return
     */
    private List<BcmApplyCommodityOrderSupplierReplyItemPO> getApplyCommodityOrderSupplierReplyItem(Long replyId) {
        BcmQueryApplyCommodityOrderSupplierReplyItemPO bcmQueryApplyCommodityOrderSupplierReplyItemPO = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setReplyId(replyId);
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return bcmApplyCommodityOrderSupplierReplyItemMapper.getList(bcmQueryApplyCommodityOrderSupplierReplyItemPO);
    }

    /**
     * 逻辑删除应答单
     *
     * @param replyId
     */
    private void updateApplyCommodityOrderSupplierReply(BcmAddBatchReplyCommodityReqBO reqBO, Long replyId) {
        BcmApplyCommodityOrderSupplierReplyPO bcmApplyCommodityOrderSupplierReplyPO = new BcmApplyCommodityOrderSupplierReplyPO();
        bcmApplyCommodityOrderSupplierReplyPO.setReplyId(replyId);
        bcmApplyCommodityOrderSupplierReplyPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        bcmApplyCommodityOrderSupplierReplyPO.setUpdateTime(new Date());
        bcmApplyCommodityOrderSupplierReplyPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyCommodityOrderSupplierReplyPO.setUpdateUserName(reqBO.getUserName());
        bcmApplyCommodityOrderSupplierReplyMapper.update(bcmApplyCommodityOrderSupplierReplyPO);
    }

    /**
     * 新增应答明细
     *
     * @param reqBO
     */
    private void addApplyCommodityOrderSupplierReplyItem(BcmAddBatchReplyCommodityReqBO reqBO, Long replyId) {
        List<BcmApplyCommodityOrderSupplierReplyItemPO> list = new ArrayList<>();
        Date now = new Date();
        List<BcmFilePO> filePOS = new ArrayList<>();
        for (BcmAddReplyCommodityBO bo : reqBO.getReplyCommodityOrderItemList()) {
            Long replyItemId = BcmIdUtil.nextId();
            BcmApplyCommodityOrderSupplierReplyItemPO po = BcmRuUtil.js(bo, BcmQueryApplyCommodityOrderSupplierReplyItemPO.class);
            po.setId(BcmIdUtil.nextId());
            po.setReplyItemId(replyItemId);
            po.setReplyId(replyId);
            po.setCommodityReplyTypes(bo.getCommodityReplyTypeId());
            po.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
            po.setPushFlag(BcmPersonalCommodityConstant.PushFlag.NO_PUSH);
            po.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
            po.setCreateUserId(reqBO.getUserId());
            po.setCreateUserName(reqBO.getUserName());
            po.setCreateTime(now);
            //应答明细附件设置
            if (!CollectionUtils.isEmpty(bo.getFileInfo())) {
                for (BcmFileBO fileBO : bo.getFileInfo()) {
                    BcmFilePO filePO = BcmRuUtil.js(fileBO, BcmFilePO.class);
                    filePO.setBusinessId(replyItemId);
                    filePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.REPLY_ORDER_ITEM);
                    filePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
                    filePO.setId(BcmIdUtil.nextId());
                    filePO.setCreateTime(now);
                    filePO.setCreateUserName(reqBO.getUserName());
                    filePO.setCreateUserId(reqBO.getUserId());
                    filePOS.add(filePO);
                }
            }
            list.add(po);
        }
        bcmApplyCommodityOrderSupplierReplyItemMapper.insertBatch(list);
        //添加附件
        if (!CollectionUtils.isEmpty(filePOS)) {
            bcmFileMapper.insertBatch(filePOS);
        }
    }


    /**
     * 逻辑删除应答明细
     *
     * @param reqBO
     * @param replyId
     */
    private void updateApplyCommodityOrderSupplierReplyItem(BcmAddBatchReplyCommodityReqBO reqBO, Long replyId) {
        BcmApplyCommodityOrderSupplierReplyItemPO bcmApplyCommodityOrderSupplierReplyItemPO = new BcmApplyCommodityOrderSupplierReplyItemPO();
        bcmApplyCommodityOrderSupplierReplyItemPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        bcmApplyCommodityOrderSupplierReplyItemPO.setReplyId(replyId);
        bcmApplyCommodityOrderSupplierReplyItemPO.setUpdateTime(new Date());
        bcmApplyCommodityOrderSupplierReplyItemPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyCommodityOrderSupplierReplyItemPO.setUpdateUserName(reqBO.getUserName());
        bcmApplyCommodityOrderSupplierReplyItemMapper.update(bcmApplyCommodityOrderSupplierReplyItemPO);
    }

    /**
     * 逻辑删除附件信息
     * @param replyId
     */
    private void updateFile(Long replyId) {
        List<BcmApplyCommodityOrderSupplierReplyItemPO> list = getApplyCommodityOrderSupplierReplyItem(replyId);
        if(!CollectionUtils.isEmpty(list)){
            List<Long> businessIdList = list.stream().map(BcmApplyCommodityOrderSupplierReplyItemPO::getReplyItemId).collect(Collectors.toList());
            BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
            bcmQueryFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.REPLY_ORDER_ITEM);
            bcmQueryFilePO.setBusinessIdList(businessIdList);
            bcmQueryFilePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
            bcmFileMapper.update(bcmQueryFilePO);
        }
    }

    /**
     * 应答单获取
     *
     * @param reqBO
     * @return
     */
    private BcmApplyCommodityOrderSupplierReplyPO getApplyCommodityOrderSupplierReply(BcmAddBatchReplyCommodityReqBO reqBO) {
        BcmQueryApplyCommodityOrderSupplierReplyPO bcmQueryApplyCommodityOrderSupplierReplyPO = new BcmQueryApplyCommodityOrderSupplierReplyPO();
        bcmQueryApplyCommodityOrderSupplierReplyPO.setApplyOrderId(reqBO.getApplyOrderId());
        bcmQueryApplyCommodityOrderSupplierReplyPO.setSupplierId(reqBO.getSupplierId());
        bcmQueryApplyCommodityOrderSupplierReplyPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return bcmApplyCommodityOrderSupplierReplyMapper.getModel(bcmQueryApplyCommodityOrderSupplierReplyPO);
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmAddBatchReplyCommodityReqBO reqBO) {

        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (reqBO.getSupplierId() == null) {
            throw new ZTBusinessException("入参供应商id不能为null");
        }
        if (reqBO.getSupplierName() == null) {
            throw new ZTBusinessException("入参供应商名不能为null");
        }
        if (reqBO.getApplyOrderId() == null) {
            throw new ZTBusinessException("入参上架申请单id不能为null");
        }
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("操作人id不能为null");
        }
        if (StringUtils.isEmpty(reqBO.getUserName())) {
            throw new ZTBusinessException("操作人名称不能为null");
        }
        if (!CollectionUtils.isEmpty(reqBO.getReplyCommodityOrderItemList())) {
            for (BcmAddReplyCommodityBO bo : reqBO.getReplyCommodityOrderItemList()) {
                if (bo.getApplyOrderId() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合上架申请单id不能为null");
                }
                if (bo.getApplyOrderItemId() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合上架申请单明细id不能为null");
                }
                if (bo.getCommodityReplyTypeId() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合商品应答类型Id不能为null");
                }
                if (bo.getFirstCatalogId() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合一级类目id不能为null");
                }
                if (StringUtils.isEmpty(bo.getFirstCatalogName())) {
                    throw new ZTBusinessException("入参应答商品明细集合一级类目名称不能为null");
                }
                if (bo.getSecondaryCatalogId() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合二级类目id不能为null");
                }
                if (StringUtils.isEmpty(bo.getSecondaryCatalogName())) {
                    throw new ZTBusinessException("入参应答商品明细集合二级类目名称不能为null");
                }
                if (bo.getThirdCatalogId() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合三级级类目id不能为null");
                }
                if (StringUtils.isEmpty(bo.getThirdCatalogName())) {
                    throw new ZTBusinessException("入参应答商品明细集合三级级类目名称不能为null");
                }
                if (bo.getCommodityTypeId() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合商品类型id不能为null");
                }
                if (StringUtils.isEmpty(bo.getCommodityTypeName())) {
                    throw new ZTBusinessException("入参应答商品明细集合商品类型名称不能为null");
                }
                if (bo.getMeterageUnitId() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合计量单位id不能为null");
                }
                if (StringUtils.isEmpty(bo.getMeterageUnitName())) {
                    throw new ZTBusinessException("入参应答商品明细集合计量单位名称不能为null");
                }
                if (bo.getSupplyNum() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合供应数量不能为null");
                }
                if(bo.getSupplyNum() <= 0){
                    throw new ZTBusinessException("入参应答商品明细集合供应数量必须为正数");
                }
                if (bo.getSalePrice() == null) {
                    throw new ZTBusinessException("入参应答商品明细集合销售价格不能为null");
                }
                if(BigDecimal.ZERO.compareTo(bo.getSalePrice())>=0){
                    throw new ZTBusinessException("入参应答商品明细集合销售价格必须为正数");
                }
                if (BcmPersonalCommodityConstant.CommodityReplyTypeId.HITCH.equals(bo.getCommodityReplyTypeId())) {
                    if (bo.getSkuId() == null) {
                        throw new ZTBusinessException("入参应答商品明细集合商品应答类型Id为挂接商品时商品id不能为null");
                    }
                    if (StringUtils.isEmpty(bo.getSkuCode())) {
                        throw new ZTBusinessException("入参应答商品明细集合商品应答类型Id为挂接商品时商品编码不能为null");
                    }
                    if (StringUtils.isEmpty(bo.getSkuName())) {
                        throw new ZTBusinessException("入参应答商品明细集合商品应答类型Id为挂接商品时商品名称不能为null");
                    }
                    if (bo.getSupplierShopId() == null) {
                        throw new ZTBusinessException("入参应答商品明细集合商品应答类型Id为挂接商品时店铺id不能为null");
                    }
                }
            }
        }

    }
}
