package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmDelITContractTypeService;
import com.tydic.bcm.personal.commodity.bo.BcmDelITContractTypeReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmDelITContractTypeRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmITContractTypeMapper;
import com.tydic.bcm.personal.po.BcmITContractTypePO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * 标题 BcmDelITContractTypeServiceImpl
 * 说明 IT合同类型管理-删除IT合同类型实现
 * 时间 2023/7/20 11:10
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmDelITContractTypeServiceImpl implements BcmDelITContractTypeService {

    @Autowired
    private BcmITContractTypeMapper bcmITContractTypeMapper;

    /**
     * 删除IT合同类型
     * @param reqBO
     * @return
     */
    @Override
    public BcmDelITContractTypeRspBO delITContractType(BcmDelITContractTypeReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmITContractTypePO bcmITContractTypePO = getBcmITContractTypePO(reqBO);
        //删除IT合同类型实现
        bcmITContractTypeMapper.updateById(bcmITContractTypePO);
        return BcmRuUtil.success(BcmDelITContractTypeRspBO.class);
    }


    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmITContractTypePO getBcmITContractTypePO(BcmDelITContractTypeReqBO reqBO){
        BcmITContractTypePO bcmITContractTypePO = new BcmITContractTypePO();
        bcmITContractTypePO.setId(reqBO.getId());
        bcmITContractTypePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        bcmITContractTypePO.setUpdateUserName(reqBO.getUserName());
        bcmITContractTypePO.setUpdateUserId(reqBO.getUserId());
        bcmITContractTypePO.setUpdateTime(new Date());
        return bcmITContractTypePO;
    }


    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmDelITContractTypeReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getId() == null){
            throw new ZTBusinessException("参数IT合同类型id不能为null");
        }
        if(reqBO.getUserId() == null){
            throw new ZTBusinessException("参数操作人id不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getUserName())){
            throw new ZTBusinessException("操作人名称不能为null");
        }
    }
}
