package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderSelectTimeLimitConfPageListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderSelTimeLimitConfBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderSelectTimeLimitConfPageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderSelectTimeLimitConfPageListRspBO;
import com.tydic.bcm.personal.dao.BcmApplyCommodityConfMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityConfPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： BcmQueryApplyOrderSelectTimeLimitConfPageListServiceImpl
 * 说明：上架申请单-选定时限配置列表查询（分页）实现
 *
 * @author： lishiqing
 * 时间： 2023/7/28 10:23
 */
@HTServiceImpl
public class BcmQueryApplyOrderSelectTimeLimitConfPageListServiceImpl implements BcmQueryApplyOrderSelectTimeLimitConfPageListService {

    @Autowired
    private BcmApplyCommodityConfMapper bcmApplyCommodityConfMapper;


    @Override
    public BcmQueryApplyOrderSelectTimeLimitConfPageListRspBO queryApplyOrderSelectTimeLimitConfPageList(BcmQueryApplyOrderSelectTimeLimitConfPageListReqBO reqBO) {
        BcmQueryApplyOrderSelectTimeLimitConfPageListRspBO rspBO = new BcmQueryApplyOrderSelectTimeLimitConfPageListRspBO();

        // 入参组装
        Page<BcmApplyCommodityConfPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        BcmApplyCommodityConfPO po = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmApplyCommodityConfPO.class);

        // 根据条件分页查询列表数据
        List<BcmApplyCommodityConfPO> bcmApplyCommodityConfPOS =  bcmApplyCommodityConfMapper.getPageList(po,page);

        // 如果为空直接返回
        if (CollectionUtil.isEmpty(bcmApplyCommodityConfPOS)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc("未查询到符合条件的数据");
            return rspBO;
        }

        // 出参组装
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(bcmApplyCommodityConfPOS) ?
                JSONObject.parseArray(JSONObject.toJSONString(bcmApplyCommodityConfPOS), BcmApplyOrderSelTimeLimitConfBO.class) : new ArrayList<>());

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
