package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmSaveOrSubmitReplyService;
import com.tydic.bcm.personal.commodity.bo.BcmSaveOrSubmitReplyReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmSaveOrSubmitReplyRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题 BcmSaveOrSubmitReplyServiceImpl
 * 说明 上架申请单应答-选定保存/提交实现
 * 时间 2023/8/2 14:18
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmSaveOrSubmitReplyServiceImpl implements BcmSaveOrSubmitReplyService {

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;



    /**
     * 上架申请单应答-选定保存/提交实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmSaveOrSubmitReplyRspBO saveOrSubmitReply(BcmSaveOrSubmitReplyReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //修改应答明细
        updateApplyCommodityOrderSupplierReplyItem(reqBO);
        //当操作类型为提交时修改上架申请单状态
        if(BcmPersonalCommodityConstant.OperType.SUBMIT.equals(reqBO.getOperType())){
             updateApplyCommodityOrder(reqBO);
        }
        return BcmRuUtil.success(BcmSaveOrSubmitReplyRspBO.class);
    }

    /**
     * 修改上架申请单
     */
    private void updateApplyCommodityOrder(BcmSaveOrSubmitReplyReqBO reqBO){
        BcmApplyCommodityOrderPO applyCommodityOrderPO = bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if(applyCommodityOrderPO == null){
            throw new ZTBusinessException("未查询到上架申请单");
        }
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = new BcmApplyCommodityOrderPO();
        bcmApplyCommodityOrderPO.setApplyOrderId(reqBO.getApplyOrderId());
        bcmApplyCommodityOrderPO.setUpdateTime(new Date());
        bcmApplyCommodityOrderPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyCommodityOrderPO.setUpdateUserName(reqBO.getName());
        bcmApplyCommodityOrderPO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.SELECTED.getStatus());
        bcmApplyCommodityOrderMapper.update(bcmApplyCommodityOrderPO);
    }

    /**
     * 修改应答明细
     */
    private void updateApplyCommodityOrderSupplierReplyItem(BcmSaveOrSubmitReplyReqBO reqBO){
        List<BcmQueryApplyCommodityOrderSupplierReplyItemPO> updateList = new ArrayList<>();
        //取消选定
        Date now = new Date();
        if(!CollectionUtils.isEmpty(reqBO.getCancelSelectIdList())){
            for (Long id: reqBO.getCancelSelectIdList()){
                BcmQueryApplyCommodityOrderSupplierReplyItemPO po = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
                po.setId(id);
                po.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.NO);
                po.setUpdateUserId(reqBO.getUserId());
                po.setUpdateUserName(reqBO.getName());
                po.setUpdateTime(now);
                updateList.add(po);
            }
        }
        //选定
        if(!CollectionUtils.isEmpty(reqBO.getSelectIdList())){
            for (Long id: reqBO.getSelectIdList()){
                BcmQueryApplyCommodityOrderSupplierReplyItemPO po = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
                po.setId(id);
                po.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
                po.setUpdateUserId(reqBO.getUserId());
                po.setUpdateUserName(reqBO.getName());
                po.setUpdateTime(now);
                updateList.add(po);
            }
        }
        if(!CollectionUtils.isEmpty(updateList)){
            bcmApplyCommodityOrderSupplierReplyItemMapper.updateBatch(updateList);
        }
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmSaveOrSubmitReplyReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getApplyOrderId() == null){
            throw new ZTBusinessException("入参上架申请单id不能为null");
        }
        if(reqBO.getUserId() == null){
            throw new ZTBusinessException("入参操作人id不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getName())){
            throw new ZTBusinessException("入参操作人名称不能为null");
        }
        if(reqBO.getOperType() == null){
            throw new ZTBusinessException("入参操作类型不能为null");
        }
    }

}
