package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.date.DateUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmUpdateStatusApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BooleanFlagEnum;
import com.tydic.bcm.personal.dao.BcmApplyCommodityConfMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityConfPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/1 09:58
 */
@HTServiceImpl
@RequiredArgsConstructor
@Slf4j
public class BcmUpdateStatusApplyCommodityOrderServiceImpl implements BcmUpdateStatusApplyCommodityOrderService {

    private final BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    private final BcmApplyCommodityConfMapper bcmApplyCommodityConfMapper;


    @Override
    public BcmUpdateStatusApplyCommodityOrderRspBO updateStatusApplyCommodityOrder(BcmUpdateStatusApplyCommodityOrderReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        BcmApplyCommodityOrderPO existCommodityOrder = bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (existCommodityOrder == null) {
            throw new ZTBusinessException("上架申请单不存在");
        }
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = BcmCommonBeanUtil.copyProperties(reqBO, BcmApplyCommodityOrderPO.class);
        //上架申请单进入选定状态
        if (BooleanFlagEnum.YES.getFlag().equals(reqBO.getSelectDeadFlag()) && existCommodityOrder.getSelectDeadlineDate() == null) {
            BcmApplyCommodityConfPO bcmApplyCommodityConf = getBcmApplyCommodityConf(existCommodityOrder.getPurCompanyId());
            bcmApplyCommodityOrder.setSelectDeadlineDate(DateUtil.offsetDay(new Date(), bcmApplyCommodityConf.getSelectDayLimit()));
        }
        bcmApplyCommodityOrderMapper.update(bcmApplyCommodityOrder);
        return BcmRuUtil.success(BcmUpdateStatusApplyCommodityOrderRspBO.class);
    }

    /**
     * 获取选定时限配置
     */
    private BcmApplyCommodityConfPO getBcmApplyCommodityConf(Long companyId) {
        BcmApplyCommodityConfPO bcmApplyCommodityConfPO = new BcmApplyCommodityConfPO();
        bcmApplyCommodityConfPO.setCompanyId(companyId);
        BcmApplyCommodityConfPO model = bcmApplyCommodityConfMapper.getModel(bcmApplyCommodityConfPO);
        if (model == null) {
            BcmApplyCommodityConfPO defaultConf = new BcmApplyCommodityConfPO();
            defaultConf.setGlobalFlag(BcmPersonalCommodityConstant.GlobalFlag.YES);
            model = bcmApplyCommodityConfMapper.getModel(defaultConf);
        }
        if (model == null) {
            throw new ZTBusinessException("未设置选定默认配置");
        }
        return model;
    }
}
