package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmFullSyncBasicProjectService;
import com.tydic.bcm.personal.common.bo.BcmBasicProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncBasicProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncBasicProjectRspBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncBasicProjectReqBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBasicProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBasicProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题 BcmFullSyncBasicProjectServiceImpl
 * 说明 项目基本信息-项目基本信息全量同步实现
 * 时间 2023/8/3 11:05
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmFullSyncBasicProjectServiceImpl implements BcmFullSyncBasicProjectService {

    @Autowired
    private BcmBasicProjectInfoMapper bcmBasicProjectInfoMapper;

    /**
     * 项目基本信息全量同步实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmFullSyncBasicProjectRspBO fullSyncBasicProject(BcmFullSyncBasicProjectReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //全量同步
        fullSync(reqBO);
        return BcmRuUtil.success(BcmFullSyncBasicProjectRspBO.class);
    }

    /**
     * 全量同步
     * @param reqBO
     */
    private void fullSync(BcmFullSyncBasicProjectReqBO reqBO){
        List<BcmBasicProjectInfoPO> bcmBasicProjectInfoPOS = BcmRuUtil.jsl(reqBO.getBasicProjectList(),BcmBasicProjectInfoPO.class);
        Date now = new Date();
        for (BcmBasicProjectInfoPO po:bcmBasicProjectInfoPOS){
            if(po.getCreateTime() == null){
                po.setCreateTime(now);
            }
            if(po.getUpdateTime() == null){
                po.setUpdateTime(now);
            }
            po.setId(BcmIdUtil.nextId());
            po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        }
        bcmBasicProjectInfoMapper.insertBatch(bcmBasicProjectInfoPOS);
    }


    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmFullSyncBasicProjectReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getBasicProjectList())){
            throw new ZTBusinessException("入参成本信息list不能为null");
        }
        for (BcmBasicProjectInfoBO bo:reqBO.getBasicProjectList()) {
            if(StringUtils.isEmpty(bo.getProjectCode())){
                throw new ZTBusinessException("入参项目编码不能为null");
            }
            if(StringUtils.isEmpty(bo.getProjectName())){
                throw new ZTBusinessException("入参项目名称不能为null");
            }
            if (StringUtils.isEmpty(bo.getProOrgCode())){
                throw new ZTBusinessException("入参采购机构编号不能为null");
            }
            if(StringUtils.isEmpty(bo.getProOrgName())){
                throw new ZTBusinessException("入参采购机构名称不能为null");
            }
            if(bo.getBudgetMoney() == null){
                throw new ZTBusinessException("入参预算金额不能为null");
            }
            if(bo.getStatus() == null){
                throw new ZTBusinessException("入参状态不能为null");
            }
        }
    }
}
