package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmFullSyncCostService;
import com.tydic.bcm.personal.common.bo.BcmCostInfoBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncCostReqBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncCostRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmCostInfoMapper;
import com.tydic.bcm.personal.po.BcmCostInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题 BcmFullSyncCostServiceImpl
 * 说明 成本中心查询-成本中心全量同步实现
 * 时间 2023/7/20 14:32
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmFullSyncCostServiceImpl implements BcmFullSyncCostService {

    @Autowired
    private BcmCostInfoMapper bcmCostInfoMapper;

    /**
     * 成本中心全量同步
     * @param reqBO
     * @return
     */
    @Override
    public BcmFullSyncCostRspBO fullSyncCost(BcmFullSyncCostReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        List<BcmCostInfoPO> bcmCostInfoPOS = getCostInfoPOList(reqBO);
        bcmCostInfoMapper.insertBatch(bcmCostInfoPOS);
        return BcmRuUtil.success(BcmFullSyncCostRspBO.class);
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private List<BcmCostInfoPO> getCostInfoPOList(BcmFullSyncCostReqBO reqBO){
        List<BcmCostInfoPO> bcmCostInfoPOS = new ArrayList<>();
        Date now = new Date();
        for (BcmCostInfoBO bo: reqBO.getCostList()) {
            BcmCostInfoPO po = JSONObject.parseObject(JSONObject.toJSONString(bo),BcmCostInfoPO.class);
            po.setId(BcmIdUtil.nextId());
            po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            if(po.getCreateTime() == null){
                po.setCreateTime(now);
            }
            if(po.getUpdateTime() == null){
                po.setUpdateTime(now);
            }
            bcmCostInfoPOS.add(po);
        }
        return bcmCostInfoPOS;

    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmFullSyncCostReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getCostList())){
            throw new ZTBusinessException("入参成本信息list不能为null");
        }
        for (BcmCostInfoBO bo:reqBO.getCostList()) {
            if(StringUtils.isEmpty(bo.getCostCenterCode())){
                throw new ZTBusinessException("入参成本中心编码不能为null");
            }
            if(StringUtils.isEmpty(bo.getCostCenterName())){
                throw new ZTBusinessException("入参成本中心名称不能为null");
            }
            if (StringUtils.isEmpty(bo.getFinancialOrgCode())){
                throw new ZTBusinessException("入参财务机构编号不能为null");
            }
            if(StringUtils.isEmpty(bo.getFinancialOrgName())){
                throw new ZTBusinessException("入参财务中心编码不能为null");

            }
            if(bo.getStatus() == null){
                throw new ZTBusinessException("入参状态不能为null");
            }
        }
    }
}
