package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQueryFlowInstanceDetailService;
import com.tydic.bcm.personal.common.bo.BcmFlowInstanceBO;
import com.tydic.bcm.personal.common.bo.BcmFlowTaskBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFlowInstanceDetailReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFlowInstanceDetailRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/1 14:06
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmQueryFlowInstanceDetailServiceImpl implements BcmQueryFlowInstanceDetailService {

    private final BcmFlowInstanceMapper flowInstanceMapper;

    private final BcmFlowTaskMapper flowTaskMapper;

    @Override
    public BcmQueryFlowInstanceDetailRspBO queryFlowInstanceDetail(BcmQueryFlowInstanceDetailReqBO bcmQueryFlowInstanceDetailReqBO) {
        if (StrUtil.isEmpty(bcmQueryFlowInstanceDetailReqBO.getFlowInstId()) && bcmQueryFlowInstanceDetailReqBO.getObjId() == null
                && ObjectUtil.isNull(bcmQueryFlowInstanceDetailReqBO.getTaskId())) {
            throw new ZTBusinessException("objId或flowInstId或taskId不能都为空");
        }
        if (bcmQueryFlowInstanceDetailReqBO.getObjId() != null && bcmQueryFlowInstanceDetailReqBO.getFlowType() == null) {
            throw new ZTBusinessException("流程类型不能为空");
        }
        BcmFlowInstancePO flowInstance;
        if (ObjectUtil.isNotNull(bcmQueryFlowInstanceDetailReqBO.getTaskId())) {
            flowInstance = flowInstanceMapper.queryByTaskId(bcmQueryFlowInstanceDetailReqBO.getTaskId());
        } else {
            flowInstance = flowInstanceMapper.queryByObjIdOrFlowInstanceId(bcmQueryFlowInstanceDetailReqBO.getObjId(), bcmQueryFlowInstanceDetailReqBO.getFlowType(), bcmQueryFlowInstanceDetailReqBO.getFlowInstId());
        }
        if (flowInstance == null) {
            throw new ZTBusinessException("流程实例不存在");
        }
        BcmFlowInstanceBO bcmFlowInstanceBO = BcmCommonBeanUtil.copyProperties(flowInstance, BcmFlowInstanceBO.class);
        if (BcmPersonalCommodityConstant.QueryTaskFlag.YES.equals(bcmQueryFlowInstanceDetailReqBO.getQueryTaskFlag())) {
            List<BcmFlowTaskPO> bcmFlowTaskPOS = flowTaskMapper.queryByFlowInstanceId(flowInstance.getFlowInstId());
            List<BcmFlowTaskBO> bcmFlowTaskList = BcmCommonBeanUtil.listCopyProperties(bcmFlowTaskPOS, BcmFlowTaskBO.class);
            bcmFlowInstanceBO.setBcmFlowTaskList(bcmFlowTaskList);
        }
        BcmQueryFlowInstanceDetailRspBO resp = new BcmQueryFlowInstanceDetailRspBO();
        resp.setFlowInstance(bcmFlowInstanceBO);
        return resp;
    }
}
