package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.bean.BeanUtil;
import com.tydic.bcm.personal.common.api.BcmUpdateFlowTaskService;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskRspBO;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/2 18:10
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmUpdateFlowTaskServiceImpl implements BcmUpdateFlowTaskService {

    private final BcmFlowTaskMapper flowTaskMapper;

    @Override
    public BcmUpdateFlowTaskRspBO updateFlowTask(BcmUpdateFlowTaskReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        BcmFlowTaskPO bcmFlowTask = BeanUtil.copyProperties(reqBO, BcmFlowTaskPO.class);
        flowTaskMapper.update(bcmFlowTask);
        return new BcmUpdateFlowTaskRspBO();
    }
}
