package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmUpdateRelPaymentProjectService;
import com.tydic.bcm.personal.common.bo.BcmUpdateRelPaymentProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdateRelPaymentProjectRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndPaymentProjectRelMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndPaymentProjectRelPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 类名： BcmUpdateRelPaymentProjectServiceImpl
 * 说明：采购用途设置-修改采购用途与收支项目关联关系实现
 *
 * @author： lishiqing
 * 时间： 2023/7/25 16:36
 */
@HTServiceImpl
public class BcmUpdateRelPaymentProjectServiceImpl implements BcmUpdateRelPaymentProjectService {

    @Autowired
    private BcmPurchasePurposeAndPaymentProjectRelMapper bcmPurchasePurposeAndPaymentProjectRelMapper;

    @Override
    public BcmUpdateRelPaymentProjectRspBO updateRelPaymentProject(BcmUpdateRelPaymentProjectReqBO reqBO) {
        BcmUpdateRelPaymentProjectRspBO rspBO = new BcmUpdateRelPaymentProjectRspBO();

        //初始话当前时间
        Date nowTime = new Date();

        // 参数校验
        verifyParam(reqBO);

        // 查询原来的关联关系
        BcmPurchasePurposeAndPaymentProjectRelPO qryPO = new BcmPurchasePurposeAndPaymentProjectRelPO();
        qryPO.setId(reqBO.getId());
        BcmPurchasePurposeAndPaymentProjectRelPO modelBy = bcmPurchasePurposeAndPaymentProjectRelMapper.getModelBy(qryPO);
        if (ObjectUtil.isEmpty(modelBy)) {
            throw new ZTBusinessException("未查询到对应关联关系");
        }

        // 逻辑删除原来的关联关系
        BcmPurchasePurposeAndPaymentProjectRelPO setPO = new BcmPurchasePurposeAndPaymentProjectRelPO();
        setPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);
        BcmPurchasePurposeAndPaymentProjectRelPO wherePO = new BcmPurchasePurposeAndPaymentProjectRelPO();
        wherePO.setUpdateUserId(reqBO.getUpdateUserId());
        wherePO.setUpdateUserName(reqBO.getUpdateUserName());
        wherePO.setUpdateOrgId(reqBO.getUpdateOrgId());
        wherePO.setUpdateOrgName(reqBO.getUpdateOrgName());
        wherePO.setUpdateCompanyId(reqBO.getUpdateCompanyId());
        wherePO.setUpdateCompanyName(reqBO.getUpdateCompanyName());
        wherePO.setUpdateTime(nowTime);
        wherePO.setId(reqBO.getId());
        int i = bcmPurchasePurposeAndPaymentProjectRelMapper.updateBy(setPO, wherePO);
        if (i < 1 ){
            throw new ZTBusinessException("修改原关联关系为失效失败");
        }

        // 新增一条关联关系
        BcmPurchasePurposeAndPaymentProjectRelPO insertPO = JSONObject.parseObject(JSONObject.toJSONString(modelBy), BcmPurchasePurposeAndPaymentProjectRelPO.class);
        insertPO.setId(BcmIdUtil.nextId());
        insertPO.setRelStatus(BcmPersonalCommonConstant.RelStatus.ASSOCIATED);
        insertPO.setPaymentProjectId(reqBO.getPaymentProjectId()+"");
        insertPO.setPaymentProjectName(reqBO.getPaymentProjectName());
        insertPO.setUpdateUserId(reqBO.getUpdateUserId());
        insertPO.setUpdateUserName(reqBO.getUpdateUserName());
        insertPO.setUpdateOrgId(reqBO.getUpdateOrgId());
        insertPO.setUpdateOrgName(reqBO.getUpdateOrgName());
        insertPO.setUpdateCompanyId(reqBO.getUpdateCompanyId());
        insertPO.setUpdateCompanyName(reqBO.getUpdateCompanyName());
        insertPO.setUpdateTime(nowTime);
        insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        int m = bcmPurchasePurposeAndPaymentProjectRelMapper.insert(insertPO);
        if (m < 1 ){
            throw new ZTBusinessException("新增关联关系失败");
        }

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmUpdateRelPaymentProjectReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("修改采购用途与收支项目关联关系入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getId())) {
            throw new ZTBusinessException("修改采购用途与收支项目关联关系入参主键ID【id】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeId())) {
            throw new ZTBusinessException("修改采购用途与收支项目关联关系入参采购用途ID【purchasePurposeId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeName())) {
            throw new ZTBusinessException("修改采购用途与收支项目关联关系入参采购用途名称【purchasePurposeName】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPaymentProjectId())) {
            throw new ZTBusinessException("修改采购用途与收支项目关联关系入参收支项目ID【paymentProjectId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPaymentProjectName())) {
            throw new ZTBusinessException("修改采购用途与收支项目关联关系入参收支项目名称【paymentProjectName】为空");
        }
    }
}
